package com.github.azbh111.utils.java.reflect.model;

import com.github.azbh111.utils.java.reflect.ReflectUtils;
import lombok.ToString;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;

/**
 * @author pyz
 * @date 2018/10/7 上午8:43
 */
@ToString(callSuper = true)
public class MethodFilter extends CommonFilter<MethodFilter> implements Predicate<Method> {

    private Class[] returnType;
    private Class[] parameterType;
    private Boolean static_;
    private Boolean final_;
    private Integer index;
    private Boolean abstract_;

    private MethodFilter() {
    }

    public static MethodFilter create() {
        return new MethodFilter();
    }

    public Class[] getReturnType() {
        return returnType;
    }

    public MethodFilter setReturnType(Class... returnType) {
        this.returnType = returnType;
        return this;
    }

    public Class[] getParameterType() {
        return parameterType;
    }

    public MethodFilter setParameterType(Class[] parameterType) {
        this.parameterType = parameterType;
        return this;
    }

    public Boolean getStatic() {
        return static_;
    }

    public MethodFilter setStatic(Boolean static_) {
        this.static_ = static_;
        return this;
    }

    public Boolean getFinal() {
        return final_;
    }

    public MethodFilter setFinal(Boolean final_) {
        this.final_ = final_;
        return this;
    }

    public Integer getIndex() {
        return index;
    }

    public MethodFilter setIndex(Integer index) {
        this.index = index;
        return this;
    }

    public Boolean getAbstract() {
        return abstract_;
    }

    public MethodFilter setAbstract(Boolean abstract_) {
        this.abstract_ = abstract_;
        return this;
    }

    @Override
    public boolean test(Method wm) {
        if (abstract_ != null) {
            if (abstract_ != Modifier.isAbstract(wm.getModifiers())) {
                return false;
            }
        }
        if (static_ != null) {
            if (static_ != Modifier.isStatic(wm.getModifiers())) {
                return false;
            }
        }
        if (final_ != null) {
            if (final_ != Modifier.isFinal(wm.getModifiers())) {
                return false;
            }
        }
        if (!super.filter(wm.getName())) {
            return false;
        }
        if (returnType != null) {
            Class realReturnType = wm.getReturnType();
            if (returnType.length == 0) {
                // 返回类型是void
                if (realReturnType != void.class) {
                    return false;
                }
            } else {
                if (!match(returnType, item -> item == realReturnType)) {
                    return false;
                }
            }
        }
        if (parameterType != null) {
            Class[] params = wm.getParameterTypes();
            if (params.length != parameterType.length) {
                return false;
            } else {
                int length = params.length;
                for (int i = 0; i < length; i++) {
                    if (params[i] != parameterType[i]) {
                        return false;
                    }
                }
            }
        }
        if (getAnnotationType() != null) {
            if (ReflectUtils.findAnnotation(wm, getAnnotationType()) == null) {
                return false;
            }
        }
        return true;
    }

}
