/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.lang;

import java.io.Serializable;
import java.util.Objects;

public class Pair<L, R>
implements Serializable,
Comparable<Pair<L, R>> {
    private static final long serialVersionUID = 8144563253158271789L;
    private L left;
    private R right;

    public static <S, T> Pair<S, T> of(S left, T right) {
        return new Pair<S, T>(left, right);
    }

    public static <L, R> int compare(Pair<L, R> left, Pair<L, R> right) {
        if (left == null) {
            if (right != null) {
                return -1;
            }
            return 0;
        }
        if (right == null) {
            return 1;
        }
        return left.compareTo(right);
    }

    public Pair() {
    }

    public Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public void setLeft(L left) {
        this.left = left;
    }

    public void setRight(R right) {
        this.right = right;
    }

    @Override
    public int compareTo(Pair<L, R> o) {
        if (this == o) {
            return 0;
        }
        L key1 = this.left;
        L key2 = o.left;
        if (key1 == null) {
            if (key2 != null) {
                return -1;
            }
        } else {
            if (key2 == null) {
                return 1;
            }
            int c = ((Comparable)key1).compareTo(key2);
            if (c != 0) {
                return c;
            }
        }
        R value1 = this.right;
        R value2 = o.right;
        if (value1 == null) {
            if (value2 != null) {
                return -1;
            }
            return 0;
        }
        if (value2 == null) {
            return 1;
        }
        return ((Comparable)value1).compareTo(value2);
    }

    public Pair<R, L> reverse() {
        return new Pair<R, L>(this.right, this.left);
    }

    public void reverseSelf() {
        L tmp = this.left;
        this.left = this.right;
        this.right = tmp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return Objects.equals(this.left, pair.left) && Objects.equals(this.right, pair.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    public String toString() {
        return "{" + this.left + ", " + this.right + '}';
    }
}

