package com.github.azbh111.utils.java.io.classpath;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

/**
 *
 * @author pyz
 * @date 2019/5/2 3:23 PM
 */
public class ClassPathUtils {
    private static final Method addURL;

    static {
        try {
            addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addURL.setAccessible(true);
        } catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addURL(URLClassLoader loader, URL url) throws InvocationTargetException, IllegalAccessException {
        addURL.invoke(loader, url);
    }
}
