package com.github.azbh111.utils.java.sys;

/**
 *
 * @author pyz
 * @date 2019/11/26 11:18 上午
 */
public class OSUtils {

    private static final String OSName;

    static {
        OSName = System.getProperty("os.name").toLowerCase();
    }

    public static String getOSName() {
        return OSName;
    }

    public static boolean isMacOS() {
        return isMac() && !OSName.contains("x");
    }

    public static boolean isMac() {
        return OSName.startsWith("mac");
    }

    public static boolean isMacOSX() {
        return isMac() && OSName.contains("x");
    }

    public static boolean isOS2() {
        return OSName.contains("os/2");
    }

    public static boolean isSolaris() {
        return OSName.contains("solaris");
    }

    public static boolean isSunOS() {
        return OSName.contains("sunos");
    }

    public static boolean isMPEiX() {
        return OSName.contains("mpe/ix");
    }

    public static boolean isHPUX() {
        return OSName.contains("hp-ux");
    }

    public static boolean isAix() {
        return OSName.contains("aix");
    }

    public static boolean isOS390() {
        return OSName.contains("os/390");
    }

    public static boolean isFreeBSD() {
        return OSName.contains("freebsd");
    }

    public static boolean isIrix() {
        return OSName.contains("irix");
    }

    public static boolean isDigitalUnix() {
        return OSName.contains("digital") && OSName.contains("unix");
    }

    public static boolean isNetWare() {
        return OSName.contains("netware");
    }

    public static boolean isOSF1() {
        return OSName.contains("osf1");
    }

    public static boolean isOpenVMS() {
        return OSName.contains("openvms");
    }

    public static boolean isWindows() {
        return OSName.startsWith("windows");
    }

    public static boolean isLinux() {
        return OSName.startsWith("linux");
    }

    public static boolean is64Bit() {
        String var0 = System.getProperty("os.arch");
        return "amd64".equals(var0) || "x86_64".equals(var0);
    }

    public static boolean is32Bit() {
        String var0 = System.getProperty("os.arch");
        return "x86".equals(var0) || "i386".equals(var0);
    }
}
