/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.iterable;

import com.github.azbh111.utils.java.annotation.Nonnull;
import com.github.azbh111.utils.java.annotation.Nullable;
import com.github.azbh111.utils.java.exception.ExceptionUtils;
import com.github.azbh111.utils.java.iterable.model.DifferenceView;
import com.github.azbh111.utils.java.iterable.model.ObjectSumFunction;
import com.github.azbh111.utils.java.map.MapUtils;
import com.github.azbh111.utils.java.predicate.PredicateUtils;
import com.github.azbh111.utils.java.reflect.ReflectUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class IterableUtils {
    public static <T> List<List<T>> splitBatch(T[] it, int batchSize) {
        return IterableUtils.splitBatch(IterableUtils.toStream(it, new Object[0][]), batchSize);
    }

    public static <T> List<List<T>> splitBatch(Iterable<T> it, int batchSize) {
        return IterableUtils.splitBatch(IterableUtils.toStream(it, new Iterable[0]), batchSize);
    }

    public static <T> List<List<T>> splitBatch(Iterator<T> it, int batchSize) {
        return IterableUtils.splitBatch(IterableUtils.toStream(it, new Iterator[0]), batchSize);
    }

    public static <T> List<List<T>> splitBatch(Stream<T> it, int batchSize) {
        if (it == null) {
            return new ArrayList<List<T>>();
        }
        ArrayList<List<T>> container = new ArrayList<List<T>>();
        ArrayList cache = new ArrayList(batchSize);
        Iterator ite = it.iterator();
        while (ite.hasNext()) {
            cache.add(ite.next());
            if (cache.size() != batchSize) continue;
            container.add(cache);
            cache = new ArrayList(batchSize);
        }
        if (!cache.isEmpty()) {
            container.add(cache);
        }
        return container;
    }

    public static <T> Stream<List<T>> splitBatchStream(Stream<T> it, int batchSize) {
        if (it == null) {
            return Stream.empty();
        }
        return IterableUtils.toStream(new StreamSpliter<T>(it, batchSize), new Iterator[0]);
    }

    public static <T> Stream<List<T>> splitBatchStream(T[] it, int batchSize) {
        return IterableUtils.splitBatchStream(IterableUtils.toStream(it, new Object[0][]), batchSize);
    }

    public static <T> Stream<List<T>> splitBatchStream(Iterable<T> it, int batchSize) {
        return IterableUtils.splitBatchStream(IterableUtils.toStream(it, new Iterable[0]), batchSize);
    }

    public static <T> Stream<List<T>> splitBatchStream(Iterator<T> it, int batchSize) {
        return IterableUtils.splitBatchStream(IterableUtils.toStream(it, new Iterator[0]), batchSize);
    }

    public static <T> int batchLoop(T[] it, int batchSize, @Nonnull Consumer<List<T>> consumer) {
        return IterableUtils.batchLoop(IterableUtils.toStream(it, new Object[0][]), batchSize, consumer);
    }

    public static <T> int batchLoop(Iterable<T> it, int batchSize, @Nonnull Consumer<List<T>> consumer) {
        return IterableUtils.batchLoop(IterableUtils.toStream(it, new Iterable[0]), batchSize, consumer);
    }

    public static <T> int batchLoop(Iterator<T> it, int batchSize, @Nonnull Consumer<List<T>> consumer) {
        return IterableUtils.batchLoop(IterableUtils.toStream(it, new Iterator[0]), batchSize, consumer);
    }

    public static <T> int batchLoop(Stream<T> stream, int batchSize, @Nonnull Consumer<List<T>> consumer) {
        if (stream == null) {
            return 0;
        }
        int[] count = new int[1];
        ArrayList cache = new ArrayList();
        stream.forEach(i -> {
            cache.add(i);
            if (cache.size() == batchSize) {
                count[0] = count[0] + batchSize;
                consumer.accept(cache);
                cache.clear();
            }
        });
        if (!cache.isEmpty()) {
            count[0] = count[0] + cache.size();
            consumer.accept(cache);
        }
        return count[0];
    }

    public static <T, K> List<T> sortByKeys(@Nullable Iterable<T> list, @Nonnull Collection<K> sortedKeys, @Nonnull Function<T, K> keyMapper) {
        Map valMap = IterableUtils.toStream(list, new Iterable[0]).collect(Collectors.toMap(keyMapper, Function.identity()));
        return sortedKeys.stream().map(i -> valMap.get(i)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T> void sum(Iterable<T> it, @Nonnull T container, Predicate<Field> fieldFilter, @Nonnull ObjectSumFunction<T> sumFunction) {
        if (it == null) {
            return;
        }
        if (IterableUtils.isNullOrEmpty(it)) {
            return;
        }
        T firstElement = IterableUtils.getFirstElement(it);
        List<Field> fields = ReflectUtils.getAllFields(firstElement.getClass(), fieldFilter);
        for (Field field : fields) {
            field.setAccessible(true);
        }
        for (Field t : it) {
            for (Field field : fields) {
                try {
                    Object appendValue = field.get(t);
                    Object currentValue = field.get(container);
                    Object newValue = sumFunction.sum(field, currentValue, t, appendValue);
                    field.set(container, newValue);
                }
                catch (IllegalAccessException e) {
                    ExceptionUtils.throwException(e);
                }
            }
        }
    }

    public static <T, K> Map<K, T> sumByKey(Iterable<T> it, Predicate<Field> fieldFilter, @Nonnull ObjectSumFunction<T> sumFunction, @Nonnull Function<T, K> keyMapper) {
        return IterableUtils.sumByKey(IterableUtils.toStream(it, new Iterable[0]), fieldFilter, sumFunction, keyMapper);
    }

    public static <T, K> Map<K, T> sumByKey(Iterator<T> it, Predicate<Field> fieldFilter, @Nonnull ObjectSumFunction<T> sumFunction, @Nonnull Function<T, K> keyMapper) {
        return IterableUtils.sumByKey(IterableUtils.toStream(it, new Iterator[0]), fieldFilter, sumFunction, keyMapper);
    }

    public static <T, K> Map<K, T> sumByKey(Stream<T> it, Predicate<Field> fieldFilter, @Nonnull ObjectSumFunction<T> sumFunction, @Nonnull Function<T, K> keyMapper) {
        if (it == null) {
            return new HashMap();
        }
        Iterator iter = it.iterator();
        if (iter == null || !iter.hasNext()) {
            return new HashMap();
        }
        List<Field> fields = null;
        HashMap map = new HashMap();
        try {
            while (iter.hasNext()) {
                Object t = iter.next();
                K key = keyMapper.apply(t);
                Object container = map.get(key);
                if (container == null) {
                    container = t.getClass().newInstance();
                    map.put(key, container);
                }
                if (fields == null) {
                    fields = ReflectUtils.getAllFields(t.getClass(), fieldFilter);
                    for (Field field : fields) {
                        field.setAccessible(true);
                    }
                }
                for (Field field : fields) {
                    Object appendValue = field.get(t);
                    Object currentValue = field.get(container);
                    Object newValue = sumFunction.sum(field, currentValue, t, appendValue);
                    field.set(container, newValue);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            ExceptionUtils.throwException(e);
        }
        return map;
    }

    public static <T> int count(Iterator<T> iterator) {
        if (iterator == null) {
            return 0;
        }
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public static <T> int count(Iterable<T> iterable) {
        if (iterable == null) {
            return 0;
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        int count = 0;
        for (T t : iterable) {
            ++count;
        }
        return count;
    }

    public static <T> DifferenceView<Set<T>> difference(Set<T> leftList, Set<T> rightList) {
        return IterableUtils.difference(leftList, rightList, new HashSet(), new HashSet(), new HashSet(), Function.identity());
    }

    public static <T, K> DifferenceView<Set<T>> difference(Set<T> leftList, Set<T> rightList, Function<T, K> identityMapper) {
        return IterableUtils.difference(leftList, rightList, new HashSet(), new HashSet(), new HashSet(), identityMapper);
    }

    public static <T, K> DifferenceView<List<T>> difference(List<T> leftList, List<T> rightList) {
        return IterableUtils.difference(leftList, rightList, Function.identity());
    }

    public static <T, K> DifferenceView<List<T>> difference(List<T> leftList, List<T> rightList, Function<T, K> identityMapper) {
        return IterableUtils.difference(leftList, rightList, new ArrayList(), new ArrayList(), new ArrayList(), identityMapper);
    }

    private static <C extends Collection<T>, T, K> DifferenceView<C> difference(Collection<T> leftList, Collection<T> rightList, C left, C common, C right, Function<T, K> identityMapper) {
        leftList = leftList == null ? new ArrayList() : leftList;
        rightList = rightList == null ? new ArrayList() : rightList;
        LinkedHashMap leftMap = new LinkedHashMap();
        for (Object t : leftList) {
            leftMap.put(identityMapper.apply(t), t);
        }
        for (Object t : rightList) {
            K k = identityMapper.apply(t);
            if (leftMap.containsKey(k)) {
                leftMap.remove(k);
                common.add(t);
                continue;
            }
            right.add(t);
        }
        left.addAll(leftMap.values());
        return DifferenceView.builder().leftOnly(left).common(common).rightOnly(right).build();
    }

    public static <T> void forEach(Consumer<T> consumer, Iterable<T> ... its) {
        if (its == null) {
            return;
        }
        for (Iterable<T> it : its) {
            for (T t : it) {
                consumer.accept(t);
            }
        }
    }

    public static <T> void distinct(Iterable<T> it) {
        IterableUtils.distinct(it, Function.identity());
    }

    public static <T, K> void distinct(Iterable<T> it, Function<T, K> distinctKey) {
        if (it == null) {
            return;
        }
        Iterator<T> iterator = it.iterator();
        HashSet<K> set = new HashSet<K>();
        while (iterator.hasNext()) {
            if (set.add(distinctKey.apply(iterator.next()))) continue;
            iterator.remove();
        }
    }

    public static <T> boolean isNullOrEmpty(Iterable<? extends T> it) {
        return it == null || !it.iterator().hasNext();
    }

    public static <T> boolean isNotNullOrEmpty(Iterable<? extends T> it) {
        return it != null && it.iterator().hasNext();
    }

    public static <T> T getLastElement(Iterable<T> it) {
        if (IterableUtils.isNullOrEmpty(it)) {
            return null;
        }
        if (it instanceof List) {
            if (it instanceof Deque) {
                Deque deque = (Deque)it;
                return (T)deque.getLast();
            }
            List list = (List)it;
            return (T)list.get(list.size() - 1);
        }
        T last = null;
        for (T t : it) {
            last = t;
        }
        return last;
    }

    public static <T> T getFirstElement(Iterable<T> it) {
        if (it == null) {
            return null;
        }
        Iterator<T> iterator = it.iterator();
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public static <T> List<T> filter(Iterable<T> it, Predicate<T> test) {
        return IterableUtils.toStream(it, new Iterable[0]).filter(test).collect(Collectors.toList());
    }

    public static <T> Optional<T> findFirst(Iterable<T> it, Predicate<T> test) {
        return IterableUtils.toStream(it, new Iterable[0]).filter(test).findFirst();
    }

    public static <Item, Key, Part> void aggregate(Map<Key, Item> target, Map<Key, Part> partMap, BiConsumer<Item, Part> partSetter) {
        for (Map.Entry<Key, Item> entry : target.entrySet()) {
            Part part = partMap.get(entry.getKey());
            if (part == null) continue;
            partSetter.accept(entry.getValue(), part);
        }
    }

    public static <Item, Key, Part> void aggregate(Map<Key, Item> target, Iterable<Part> parts, Function<Part, Key> keyGetter, BiConsumer<Item, Part> partSetter) {
        for (Part part : parts) {
            Key key = keyGetter.apply(part);
            Item item = target.get(key);
            if (item == null) continue;
            partSetter.accept(item, part);
        }
    }

    public static <Item, Key, Part> void aggregate(Iterable<Item> target, Map<Key, Part> partMap, Function<Item, Key> keyGetter, BiConsumer<Item, Part> partSetter) {
        for (Item item : target) {
            Part part = partMap.get(keyGetter.apply(item));
            if (part == null) continue;
            partSetter.accept(item, part);
        }
    }

    public static <T, R> Map<R, List<T>> groupingBy(Iterable<? extends T> it, Function<? super T, ? extends R> keyMapper) {
        return IterableUtils.groupingBy(it, keyMapper, Function.identity());
    }

    public static <T, R> Map<R, List<T>> groupingBy(Iterator<? extends T> it, Function<? super T, ? extends R> keyMapper) {
        return IterableUtils.groupingBy(it, keyMapper, Function.identity());
    }

    public static <T, R> Map<R, List<T>> groupingBy(T[] it, Function<? super T, ? extends R> keyMapper) {
        return IterableUtils.groupingBy(it, keyMapper, Function.identity());
    }

    public static <T, R> Map<R, List<T>> groupingBy(Stream<? extends T> it, Function<? super T, ? extends R> keyMapper) {
        return IterableUtils.groupingBy(it, keyMapper, Function.identity());
    }

    public static <T, K, V> Map<K, List<V>> groupingBy(Iterable<? extends T> it, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return IterableUtils.groupingBy(IterableUtils.toStream(it, new Iterable[0]), keyMapper, valueMapper);
    }

    public static <T, K, V> Map<K, List<V>> groupingBy(Iterator<? extends T> it, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return IterableUtils.groupingBy(IterableUtils.toStream(it, new Iterator[0]), keyMapper, valueMapper);
    }

    public static <T, K, V> Map<K, List<V>> groupingBy(T[] it, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return IterableUtils.groupingBy(IterableUtils.toStream(it, new Object[0][]), keyMapper, valueMapper);
    }

    public static <T, K, V> Map<K, List<V>> groupingBy(Stream<? extends T> it, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return IterableUtils.groupingBy(it, new HashMap(), keyMapper, valueMapper);
    }

    public static <T, K, V> Map<K, List<V>> groupingBy(Stream<? extends T> it, Map<K, List<V>> resultContainer, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        it.forEach(t -> MapUtils.getOrCreate(resultContainer, Objects.requireNonNull(keyMapper.apply(t), "element cannot be mapped to a null key"), ArrayList::new).add(valueMapper.apply(t)));
        return resultContainer;
    }

    public static <T, R, A> R collect(T[] it, Collector<? super T, A, R> collector) {
        return IterableUtils.collect(IterableUtils.toStream(it, new Object[0][]), collector);
    }

    public static <T, R, A> R collect(Iterable<T> it, Collector<? super T, A, R> collector) {
        return IterableUtils.collect(IterableUtils.toStream(it, new Iterable[0]), collector);
    }

    public static <T, R, A> R collect(Iterator<T> it, Collector<? super T, A, R> collector) {
        return IterableUtils.collect(IterableUtils.toStream(it, new Iterator[0]), collector);
    }

    public static <T, R, A> R collect(Stream<? extends T> it, Collector<? super T, A, R> collector) {
        return it.collect(collector);
    }

    public static <T> Set<T> toSet(Iterable<? extends T> it) {
        return IterableUtils.toSet(it, Function.identity());
    }

    public static <T> Set<T> toSet(T[] it) {
        return IterableUtils.toSet(it, Function.identity());
    }

    public static <T> Set<T> toSet(Stream<? extends T> it) {
        return IterableUtils.toSet(it, Function.identity());
    }

    public static <T, R> Set<R> toSet(Iterable<? extends T> it, Function<? super T, ? extends R> func) {
        return IterableUtils.toSet(IterableUtils.toStream(it, new Iterable[0]), func);
    }

    public static <T, R> Set<R> toSet(Iterable<? extends T> it, Function<? super T, ? extends R> func, Predicate<? super T> predicate) {
        return IterableUtils.toSet(IterableUtils.toStream(it, new Iterable[0]), func, predicate);
    }

    public static <T, R> Set<R> toSet(T[] it, Function<? super T, ? extends R> func) {
        return IterableUtils.toSet(IterableUtils.toStream(it, new Object[0][]), func);
    }

    public static <T, R> Set<R> toSet(Stream<? extends T> it, Function<? super T, ? extends R> func) {
        return it.map(func).collect(Collectors.toSet());
    }

    public static <T, R> Set<R> toSet(Stream<? extends T> it, Function<? super T, ? extends R> func, Predicate<? super T> predicate) {
        return it.filter(predicate).map(func).collect(Collectors.toSet());
    }

    public static <T, R> List<R> flatToList(Iterable<? extends T> it, Function<? super T, Iterable<R>> func) {
        return IterableUtils.flatToList(IterableUtils.toStream(it, new Iterable[0]), func);
    }

    public static <T, R> List<R> flatToList(T[] it, Function<? super T, Iterable<R>> func) {
        return IterableUtils.flatToList(IterableUtils.toStream(it, new Object[0][]), func);
    }

    public static <T, R> List<R> flatToList(Stream<? extends T> it, Function<? super T, Iterable<R>> func) {
        return it.flatMap(item -> IterableUtils.toStream((Iterable)func.apply(item), new Iterable[0])).collect(Collectors.toList());
    }

    public static <T, R> Set<R> flatToSet(Iterable<? extends T> it, Function<? super T, Iterable<R>> func) {
        return IterableUtils.flatToSet(IterableUtils.toStream(it, new Iterable[0]), func);
    }

    public static <T, R> Set<R> flatToSet(T[] it, Function<? super T, Iterable<R>> func) {
        return IterableUtils.flatToSet(IterableUtils.toStream(it, new Object[0][]), func);
    }

    public static <T, R> Set<R> flatToSet(Stream<? extends T> it, Function<? super T, Iterable<R>> func) {
        return it.flatMap(item -> IterableUtils.toStream((Iterable)func.apply(item), new Iterable[0])).collect(Collectors.toSet());
    }

    public static <T> List<T> toList(Iterable<? extends T> it) {
        return IterableUtils.toList(it, Function.identity());
    }

    public static <T> List<T> toList(T[] it) {
        return IterableUtils.toList(it, Function.identity());
    }

    public static <T> List<T> toList(Stream<? extends T> it) {
        return IterableUtils.toList(it, Function.identity());
    }

    public static <T, R> List<R> toList(Iterable<? extends T> it, Function<? super T, R> func) {
        return IterableUtils.toList(IterableUtils.toStream(it, new Iterable[0]), func);
    }

    public static <T, R> List<R> toList(T[] it, Function<? super T, R> func) {
        return IterableUtils.toList(IterableUtils.toStream(it, new Object[0][]), func);
    }

    public static <T, R> List<R> toList(Stream<? extends T> it, Function<? super T, R> func) {
        return it.map(func).collect(Collectors.toList());
    }

    public static <T> List<T> toDistinctedList(Iterable<? extends T> it) {
        return IterableUtils.toStream(it, new Iterable[0]).distinct().collect(Collectors.toList());
    }

    public static <T, R> List<R> toDistinctedList(Iterable<? extends T> it, Function<? super T, R> func) {
        return IterableUtils.toDistinctedList(IterableUtils.toStream(it, new Iterable[0]), func);
    }

    public static <T, R> List<R> toDistinctedList(Stream<? extends T> it, Function<? super T, R> func) {
        return it.map(func).distinct().collect(Collectors.toList());
    }

    public static <T, R> List<T> toDistinctedListBy(Iterable<? extends T> it, Function<? super T, R> func) {
        return IterableUtils.toDistinctedListBy(IterableUtils.toStream(it, new Iterable[0]), func);
    }

    public static <T, R> List<T> toDistinctedListBy(Stream<? extends T> it, Function<? super T, R> func) {
        ArrayList list = new ArrayList();
        Predicate test = PredicateUtils.distinctBy(func);
        it.forEach(item -> {
            if (test.test(item)) {
                list.add(item);
            }
        });
        return list;
    }

    public static <T, R> Map<R, T> toMap(Iterable<? extends T> it, Function<? super T, ? extends R> keyMapper) {
        return IterableUtils.toMap(it, keyMapper, Function.identity());
    }

    public static <T, R> Map<R, T> toMap(T[] it, Function<? super T, ? extends R> keyMapper) {
        return IterableUtils.toMap(it, keyMapper, Function.identity());
    }

    public static <T, R> Map<R, T> toMap(Stream<? extends T> it, Function<? super T, ? extends R> keyMapper) {
        return IterableUtils.toMap(it, keyMapper, Function.identity());
    }

    public static <T, R, X> Map<R, X> toMap(Iterable<? extends T> it, Function<? super T, ? extends R> keyMapper, Function<? super T, ? extends X> valueMapper) {
        return IterableUtils.toMap(IterableUtils.toStream0(it), keyMapper, valueMapper);
    }

    public static <T, R, X> Map<R, X> toMap(T[] it, Function<? super T, ? extends R> keyMapper, Function<? super T, ? extends X> valueMapper) {
        return IterableUtils.toMap(IterableUtils.toStream(it, new Object[0][]), keyMapper, valueMapper);
    }

    public static <T, R, X> Map<R, X> toMap(Stream<? extends T> it, Function<? super T, ? extends R> keyMapper, Function<? super T, ? extends X> valueMapper) {
        return it.collect(Collectors.toMap(keyMapper, valueMapper));
    }

    public static <T> Stream<T> toStream(Iterator<T> it, Iterator<T> ... its) {
        Stream<T> stream = IterableUtils.toStream0(it);
        if (its == null) {
            return stream;
        }
        for (Iterator<T> ts : its) {
            stream = Stream.concat(stream, IterableUtils.toStream0(ts));
        }
        return stream;
    }

    public static <T> Stream<T> toStream(Iterable<T> it, Iterable<T> ... its) {
        Stream<T> stream = IterableUtils.toStream0(it);
        if (its == null) {
            return stream;
        }
        for (Iterable<T> ts : its) {
            stream = Stream.concat(stream, IterableUtils.toStream0(ts));
        }
        return stream;
    }

    public static <T> Stream<T> toStream(T[] it, T[] ... its) {
        Stream<T> stream = IterableUtils.toStream0(it);
        if (its == null) {
            return stream;
        }
        for (T[] ts : its) {
            stream = Stream.concat(stream, IterableUtils.toStream0(ts));
        }
        return stream;
    }

    public static <T> Stream<T> toStream(Stream<T> s, Stream<T> ... ss) {
        Stream stream = s == null ? Stream.empty() : s;
        for (Stream<T> ts : ss) {
            stream = Stream.concat(stream, ts);
        }
        return stream;
    }

    private static <T> Stream<T> toStream0(Iterator<T> it) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false);
    }

    private static <T> Stream<T> toStream0(Iterable<T> it) {
        if (it == null) {
            return Stream.empty();
        }
        return StreamSupport.stream(it.spliterator(), false);
    }

    private static <T> Stream<T> toStream0(T[] it) {
        if (it == null) {
            return Stream.empty();
        }
        return StreamSupport.stream(Arrays.spliterator(it), false);
    }

    public static <T extends Comparable> T max(Iterable<? extends T> it) {
        return (T)((Comparable)IterableUtils.max(it, Comparable::compareTo));
    }

    public static <T extends Comparable> T max(T[] it) {
        return (T)((Comparable)IterableUtils.max(it, Comparable::compareTo));
    }

    public static <T extends Comparable> T max(Stream<? extends T> it) {
        return (T)((Comparable)IterableUtils.max(it, Comparable::compareTo));
    }

    public static <T> T max(Iterable<T> it, Comparator<T> comparator) {
        return IterableUtils.max(IterableUtils.toStream(it, new Iterable[0]), comparator);
    }

    public static <T> T max(T[] it, Comparator<T> comparator) {
        return (T)IterableUtils.max(IterableUtils.toStream(it, new Object[0][]), comparator);
    }

    public static <T> T max(Stream<T> it, Comparator<T> comparator) {
        return it.max(comparator).orElse(null);
    }

    public static <T extends Comparable> T min(Iterable<? extends T> it) {
        return (T)((Comparable)IterableUtils.min(it, Comparable::compareTo));
    }

    public static <T extends Comparable> T min(T[] it) {
        return (T)((Comparable)IterableUtils.min(it, Comparable::compareTo));
    }

    public static <T extends Comparable> T min(Stream<? extends T> it) {
        return (T)((Comparable)IterableUtils.min(it, Comparable::compareTo));
    }

    public static <T> T min(Iterable<T> it, Comparator<T> comparator) {
        return IterableUtils.min(IterableUtils.toStream(it, new Iterable[0]), comparator);
    }

    public static <T> T min(T[] it, Comparator<T> comparator) {
        return (T)IterableUtils.min(IterableUtils.toStream(it, new Object[0][]), comparator);
    }

    public static <T> T min(Stream<T> it, Comparator<T> comparator) {
        return it.min(comparator).orElse(null);
    }

    public static class StreamSpliter<T>
    implements Iterator<List<T>> {
        private Iterator<T> it;
        private int batchSize;
        private List<T> batchList;

        public StreamSpliter(Stream<T> it, int batchSize) {
            this.it = it.iterator();
            this.batchSize = batchSize;
            this.prepareNext();
        }

        @Override
        public boolean hasNext() {
            return this.batchList != null && !this.batchList.isEmpty();
        }

        private void prepareNext() {
            this.batchList = new ArrayList<T>(this.batchSize);
            while (this.batchList.size() < this.batchSize && this.it.hasNext()) {
                this.batchList.add(this.it.next());
            }
        }

        @Override
        public List<T> next() {
            List<T> re = this.batchList;
            this.prepareNext();
            return re;
        }
    }
}

