/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.random;

import com.github.azbh111.utils.java.annotation.Nonnull;
import com.github.azbh111.utils.java.string.StringUtils;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

public class RandomUtils {
    private static final SecureRandom random;
    private static final char[] numbers;
    private static final char[] letters_lower;
    private static final char[] letters_upper;
    private static final char[] letters;
    private static final char[] common_chars;

    public static byte[] nextBytes(int length) {
        if (length == 0) {
            return new byte[0];
        }
        byte[] container = new byte[length];
        RandomUtils.nextBytes(container);
        return container;
    }

    public static void nextBytes(byte[] bytes) {
        random.nextBytes(bytes);
    }

    public static int[] nextInts(int length) {
        if (length == 0) {
            return new int[0];
        }
        int[] container = new int[length];
        RandomUtils.nextInts(container);
        return container;
    }

    public static void nextInts(int[] container) {
        int length = container.length;
        for (int i = 0; i < length; ++i) {
            container[i] = RandomUtils.nextInt();
        }
    }

    public static int nextInt() {
        return random.nextInt();
    }

    public static int nextInt(int bound) {
        return random.nextInt(bound);
    }

    public static long[] nextLongs(int length) {
        if (length == 0) {
            return new long[0];
        }
        long[] container = new long[length];
        RandomUtils.nextLongs(container);
        return container;
    }

    public static void nextLongs(long[] container) {
        int length = container.length;
        for (int i = 0; i < length; ++i) {
            container[i] = RandomUtils.nextLong();
        }
    }

    public static long nextLong() {
        return random.nextLong();
    }

    public static float[] nextFloats(int length) {
        if (length == 0) {
            return new float[0];
        }
        float[] container = new float[length];
        RandomUtils.nextFloats(container);
        return container;
    }

    public static void nextFloats(float[] container) {
        int length = container.length;
        for (int i = 0; i < length; ++i) {
            container[i] = RandomUtils.nextFloat();
        }
    }

    public static float nextFloat() {
        return random.nextFloat();
    }

    public static double[] nextDoubles(int length) {
        if (length == 0) {
            return new double[0];
        }
        double[] container = new double[length];
        RandomUtils.nextDoubles(container);
        return container;
    }

    public static void nextDoubles(double[] container) {
        int length = container.length;
        for (int i = 0; i < length; ++i) {
            container[i] = RandomUtils.nextDouble();
        }
    }

    public static double nextDouble() {
        return random.nextDouble();
    }

    public static boolean[] nextBooleans(int length) {
        if (length == 0) {
            return new boolean[0];
        }
        boolean[] container = new boolean[length];
        RandomUtils.nextBooleans(container);
        return container;
    }

    public static void nextBooleans(boolean[] container) {
        int length = container.length;
        for (int i = 0; i < length; ++i) {
            container[i] = RandomUtils.nextBoolean();
        }
    }

    public static boolean nextBoolean() {
        return random.nextBoolean();
    }

    public static double nextGaussian() {
        return random.nextGaussian();
    }

    public static String nextString(int count, @Nonnull char[] candidates, int start, int end) {
        if (count <= 0) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end > candidates.length) {
            end = candidates.length;
        }
        if (end <= start) {
            return "";
        }
        char[] chars = new char[count];
        int candidateLength = end - start;
        for (int i = 0; i < count; ++i) {
            chars[i] = candidates[random.nextInt(candidateLength) + start];
        }
        return StringUtils.newStringZeroCopy(chars);
    }

    public static String nextString(int count, @Nonnull char[] candidates) {
        return RandomUtils.nextString(count, candidates, 0, candidates.length);
    }

    public static String nextString(int count) {
        return RandomUtils.nextString(count, common_chars);
    }

    public static String nextNumberString(int count) {
        return RandomUtils.nextString(count, numbers);
    }

    public static String nextLetterLowerString(int count) {
        return RandomUtils.nextString(count, letters_lower);
    }

    public static String nextLetterUpperString(int count) {
        return RandomUtils.nextString(count, letters_upper);
    }

    public static String nextLetterString(int count) {
        return RandomUtils.nextString(count, letters);
    }

    static {
        SecureRandom r;
        numbers = "0123456789".toCharArray();
        letters_lower = "abcdefghijklmnopqrstuvwxyz".toCharArray();
        letters_upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        common_chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        try {
            r = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            Random rd = new Random();
            byte[] seed = new byte[1024];
            rd.nextBytes(seed);
            r = new SecureRandom(seed);
        }
        random = r;
    }
}

