/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.reflect.model;

import com.github.azbh111.utils.java.reflect.model.UnsafeField;
import com.github.azbh111.utils.java.unsafe.UnsafeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class ClassCopyDesc<T> {
    private Class<T> clazz;
    private List<UnsafeField> fields = new ArrayList<UnsafeField>();
    private Constructor constructor;

    private ClassCopyDesc() {
    }

    public static <T> ClassCopyDesc<T> of(Class<T> clazz) {
        ClassCopyDesc<T> copyer = new ClassCopyDesc<T>();
        copyer.clazz = clazz;
        try {
            copyer.constructor = clazz.getConstructor(new Class[0]);
            copyer.constructor.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        for (Class<T> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                UnsafeField uf = UnsafeField.builder().field(field).offset(UnsafeUtils.objectFieldOffset(field)).type(field.getType()).build();
                copyer.getFields().add(uf);
            }
        }
        return copyer;
    }

    public T newInstance() throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (this.constructor != null) {
            return this.constructor.newInstance(new Object[0]);
        }
        return UnsafeUtils.allocateInstance(this.clazz);
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public List<UnsafeField> getFields() {
        return this.fields;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClassCopyDesc{");
        sb.append("clazz=").append(this.clazz);
        sb.append(", fields=").append(this.fields);
        sb.append(", constructor=").append(this.constructor);
        sb.append('}');
        return sb.toString();
    }
}

