/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.collection;

import com.github.azbh111.utils.java.iterable.IterableUtils;
import com.github.azbh111.utils.java.model.SortWrpper;
import com.github.azbh111.utils.java.predicate.PredicateUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CollectionUtils {
    public static <T> void distinctByKey(Collection<T> items, Function<T, Object> keyMapper) {
        if (items == null || items.isEmpty()) {
            return;
        }
        List noConflict = items.stream().filter(PredicateUtils.distinctBy(keyMapper)).collect(Collectors.toList());
        items.clear();
        items.addAll(noConflict);
    }

    public static <T, K> void sortMissingAtFirst(Collection<T> items, Collection<K> keys, Function<T, K> keyMapper) {
        CollectionUtils.sort(items, keys, keyMapper, Integer.MIN_VALUE);
    }

    public static <T, K> void sortMissingAtLast(Collection<T> items, Collection<K> keys, Function<T, K> keyMapper) {
        CollectionUtils.sort(items, keys, keyMapper, Integer.MAX_VALUE);
    }

    private static <T, K> void sort(Collection<T> items, Collection<K> keys, Function<T, K> keyMapper, int missingSort) {
        if (items == null || items.isEmpty()) {
            return;
        }
        if (keys == null || keys.isEmpty()) {
            return;
        }
        HashMap sortMap = new HashMap();
        int index = 0;
        for (K key : keys) {
            sortMap.put(key, index++);
        }
        List<SortWrpper> toSort = IterableUtils.toList(items, item -> new SortWrpper<Comparable, Object>(sortMap.getOrDefault(keyMapper.apply(item), missingSort), item));
        Collections.sort(toSort);
        items.clear();
        for (SortWrpper wrapper : toSort) {
            items.add(wrapper.getData());
        }
    }
}

