/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandLine {
    private String[] args;
    private Map<String, List<String>> kwargs;

    public static CommandLine of(String prefix, char quote, String line) {
        if (line == null) {
            return null;
        }
        CommandLine cl = new CommandLine();
        if (line.isEmpty()) {
            return cl;
        }
        String[] parts = CommandLine.split(quote, '\\', line);
        ArrayList<String> args = new ArrayList<String>();
        HashMap<String, List<String>> kwargs = new HashMap<String, List<String>>();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.startsWith(prefix) && part.length() > prefix.length()) {
                String name = part.substring(prefix.length());
                String v = i + 1 < parts.length ? parts[i + 1] : "";
                kwargs.computeIfAbsent(name, k -> new ArrayList()).add(v);
                ++i;
                continue;
            }
            args.add(part);
        }
        cl.args = args.toArray(new String[args.size()]);
        cl.kwargs = kwargs;
        return cl;
    }

    public static String[] split(char quote, char escape, String line) {
        if (line == null) {
            return null;
        }
        if (line.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder part = null;
        Status status = Status.whitespace;
        int idx = -1;
        while (true) {
            if (++idx >= line.length()) {
                if (status == Status.quote) {
                    throw new RuntimeException("\u672a\u7ed3\u675f\u7684\u5f15\u53f7: " + line);
                }
                if (part != null) {
                    parts.add(part.toString());
                }
                break;
            }
            char c = line.charAt(idx);
            if (status == Status.whitespace) {
                if (Character.isWhitespace(c)) continue;
                part = new StringBuilder();
                if (c == escape) {
                    status = Status.normal;
                    c = line.charAt(++idx);
                    part.append(c);
                    continue;
                }
                if (c == quote) {
                    status = Status.quote;
                    continue;
                }
                status = Status.normal;
                part.append(c);
                continue;
            }
            if (status == Status.normal) {
                if (Character.isWhitespace(c)) {
                    status = Status.whitespace;
                    parts.add(part.toString());
                    part = null;
                    continue;
                }
                if (c == escape) {
                    c = line.charAt(++idx);
                    part.append(c);
                    continue;
                }
                part.append(c);
                continue;
            }
            if (status != Status.quote) continue;
            if (c == escape) {
                c = line.charAt(++idx);
                part.append(c);
                continue;
            }
            if (c == quote) {
                status = Status.whitespace;
                parts.add(part.toString());
                part = null;
                continue;
            }
            part.append(c);
        }
        part = null;
        return parts.toArray(new String[parts.size()]);
    }

    public String[] getArgs() {
        return this.args;
    }

    public Map<String, List<String>> getKwargs() {
        return this.kwargs;
    }

    private static enum Status {
        normal,
        whitespace,
        quote;

    }
}

