/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.csv;

import com.github.azbh111.utils.java.charset.Charsets;
import com.github.azbh111.utils.java.csv.CsvColumn;
import com.github.azbh111.utils.java.csv.CsvColumnDefine;
import com.github.azbh111.utils.java.csv.CsvExporterTask;
import com.github.azbh111.utils.java.reflect.ReflectUtils;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class CsvExporter {
    private final Map<Class, List<CsvColumnDefine>> cache = new ConcurrentHashMap<Class, List<CsvColumnDefine>>();
    private final Map<Class, Function<Object, String>> toStringMapping = new ConcurrentHashMap<Class, Function<Object, String>>();
    private final Map<String, Function<Object, String>> formatMapping = new ConcurrentHashMap<String, Function<Object, String>>();
    private final Function<Object, String> toStringConventor = x -> String.valueOf(x);
    private Charset charset = Charsets.UTF_8;

    public void registerToStringConventor(Class srcType, Function<Object, String> conventor) {
        this.toStringMapping.put(srcType, conventor);
    }

    public CsvExporterTask newTask(Class cls, OutputStream outputStream) {
        return new CsvExporterTask(this, cls, outputStream);
    }

    public CsvExporterTask newTask(Class cls, Writer writer) {
        return new CsvExporterTask(this, cls, writer);
    }

    List<CsvColumnDefine> getColumns(Class cls) {
        CsvColumnDefine define;
        CsvColumn config;
        List<CsvColumnDefine> defines = this.cache.get(cls);
        if (defines != null) {
            return defines;
        }
        ArrayList<CsvColumnDefine> fieldWrappers = new ArrayList<CsvColumnDefine>();
        for (Field f : ReflectUtils.getAllFields(cls)) {
            if (!f.isAnnotationPresent(CsvColumn.class)) continue;
            f.setAccessible(true);
            config = f.getAnnotation(CsvColumn.class);
            define = CsvColumnDefine.builder().field(f).order(config.order()).name(config.value()).conventor(this.getConventor(f.getType(), config)).nullValue(config.nullValue()).build();
            fieldWrappers.add(define);
        }
        for (Method m : ReflectUtils.getAllMethods(cls)) {
            if (!m.isAnnotationPresent(CsvColumn.class)) continue;
            m.setAccessible(true);
            config = m.getAnnotation(CsvColumn.class);
            define = CsvColumnDefine.builder().method(m).order(config.order()).name(config.value()).conventor(this.getConventor(m.getReturnType(), config)).nullValue(config.nullValue()).build();
            fieldWrappers.add(define);
        }
        fieldWrappers.sort(Comparator.comparingInt(CsvColumnDefine::getOrder));
        defines = Collections.unmodifiableList(fieldWrappers);
        this.cache.put(cls, defines);
        return defines;
    }

    private Function<Object, String> getConventor(Class cls, final CsvColumn config) {
        Function<Object, String> conventor;
        if (!config.format().isEmpty()) {
            String format = config.format();
            String key = cls.getName() + ":" + config.format();
            Function<Object, String> mapper = this.formatMapping.get(key);
            if (mapper != null) {
                return mapper;
            }
            if (TemporalAccessor.class.isAssignableFrom(cls)) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(config.format());
                mapper = x -> formatter.format((TemporalAccessor)x);
            } else if (Date.class == cls) {
                mapper = new Function<Object, String>(){
                    private final String formatter;
                    private final ThreadLocal<SimpleDateFormat> threadLocal;
                    {
                        this.formatter = config.format();
                        this.threadLocal = new ThreadLocal();
                    }

                    @Override
                    public String apply(Object o) {
                        SimpleDateFormat format = this.threadLocal.get();
                        if (format == null) {
                            format = new SimpleDateFormat(this.formatter);
                            this.threadLocal.set(format);
                        }
                        return format.format((Date)o);
                    }
                };
            } else if (cls == Float.TYPE || cls == Float.class || cls == Double.TYPE || cls == Double.class || cls == BigDecimal.class) {
                mapper = x -> String.format(format, x);
            }
            if (mapper != null) {
                this.formatMapping.put(key, mapper);
                return mapper;
            }
        }
        return (conventor = this.toStringMapping.get(cls)) == null ? this.toStringConventor : conventor;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }
}

