/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.io;

import com.github.azbh111.utils.java.lang.LazyField;
import com.github.azbh111.utils.java.promise.Promise;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class IOUtils {
    private static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final LazyField<ThreadPoolExecutor> executor = LazyField.from(() -> new ThreadPoolExecutor(1, 1024, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>()));

    public static long copy(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copy(input, output, new byte[4096]);
    }

    public static Promise copyAsync(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        Promise p = new Promise();
        executor.get().execute(() -> {
            try {
                long count = 0L;
                int n = 0;
                while (-1 != (n = input.read(buffer))) {
                    output.write(buffer, 0, n);
                    count += (long)n;
                }
                p.resolve(count);
            }
            catch (Throwable x) {
                p.reject(x);
            }
        });
        return p;
    }

    public static Promise copyAsync(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copyAsync(input, output, new byte[4096]);
    }

    public static byte[] readBytes(URL input) throws IOException {
        try (InputStream is = IOUtils.openInputStream(input);){
            byte[] byArray = IOUtils.readBytes(is);
            return byArray;
        }
    }

    public static byte[] readBytes(File input) throws IOException {
        try (InputStream is = IOUtils.openInputStream(input);){
            byte[] byArray = IOUtils.readBytes(is);
            return byArray;
        }
    }

    public static byte[] readBytes(Socket input) throws IOException {
        try (InputStream is = IOUtils.openInputStream(input);){
            byte[] byArray = IOUtils.readBytes(is);
            return byArray;
        }
    }

    public static byte[] readBytes(InputStream input) throws IOException {
        int size;
        ByteArrayOutputStream res = new ByteArrayOutputStream();
        byte[] cache = new byte[128];
        while ((size = input.read(cache)) != -1) {
            res.write(cache, 0, size);
        }
        return res.toByteArray();
    }

    public static String readString(URL input, Charset charset) throws IOException {
        try (InputStream is = IOUtils.openInputStream(input);){
            String string = IOUtils.readString(new InputStreamReader(is, charset));
            return string;
        }
    }

    public static String readString(Socket input, Charset charset) throws IOException {
        try (InputStream is = IOUtils.openInputStream(input);){
            String string = IOUtils.readString(new InputStreamReader(is, charset));
            return string;
        }
    }

    public static String readString(File input, Charset charset) throws IOException {
        try (InputStream is = IOUtils.openInputStream(input);){
            String string = IOUtils.readString(new InputStreamReader(is, charset));
            return string;
        }
    }

    public static String readString(InputStream input, Charset charset) throws IOException {
        return IOUtils.readString(new InputStreamReader(input, charset));
    }

    public static String readString(Reader reader) throws IOException {
        int size;
        StringBuilder sb = new StringBuilder();
        char[] cache = new char[128];
        while ((size = reader.read(cache)) != -1) {
            sb.append(cache, 0, size);
        }
        return sb.toString();
    }

    public static List<String> readLines(Socket input, Charset charset) throws IOException {
        try (InputStream is = IOUtils.openInputStream(input);){
            List<String> list = IOUtils.readLines(new InputStreamReader(is, charset));
            return list;
        }
    }

    public static List<String> readLines(URL input, Charset charset) throws IOException {
        try (InputStream is = IOUtils.openInputStream(input);){
            List<String> list = IOUtils.readLines(new InputStreamReader(is, charset));
            return list;
        }
    }

    public static List<String> readLines(File input, Charset charset) throws IOException {
        try (InputStream is = IOUtils.openInputStream(input);){
            List<String> list = IOUtils.readLines(new InputStreamReader(is, charset));
            return list;
        }
    }

    public static List<String> readLines(InputStream input, Charset charset) throws IOException {
        return IOUtils.readLines(new InputStreamReader(input, charset));
    }

    public static List<String> readLines(Reader reader) throws IOException {
        BufferedReader br = IOUtils.toBufferedReader(reader);
        ArrayList<String> list = new ArrayList<String>();
        String line = null;
        while ((line = br.readLine()) != null) {
            list.add(line);
        }
        return list;
    }

    public static void readLineLarge(Socket input, Charset charset, Consumer<String> consumer) throws IOException {
        try (InputStream is = IOUtils.openInputStream(input);){
            IOUtils.readLineLarge(new InputStreamReader(is, charset), consumer);
        }
    }

    public static void readLineLarge(URL input, Charset charset, Consumer<String> consumer) throws IOException {
        try (InputStream is = IOUtils.openInputStream(input);){
            IOUtils.readLineLarge(new InputStreamReader(is, charset), consumer);
        }
    }

    public static void readLineLarge(File input, Charset charset, Consumer<String> consumer) throws IOException {
        try (InputStream is = IOUtils.openInputStream(input);){
            IOUtils.readLineLarge(new InputStreamReader(is, charset), consumer);
        }
    }

    public static void readLineLarge(InputStream input, Charset charset, Consumer<String> consumer) throws IOException {
        IOUtils.readLineLarge(new InputStreamReader(input, charset), consumer);
    }

    public static void readLineLarge(Reader reader, Consumer<String> consumer) throws IOException {
        BufferedReader br = IOUtils.toBufferedReader(reader);
        String line = null;
        while ((line = br.readLine()) != null) {
            consumer.accept(line);
        }
    }

    private static BufferedReader toBufferedReader(Reader reader) {
        BufferedReader br = reader == null || reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        return br;
    }

    public static InputStream openInputStream(URL input) throws IOException {
        return input == null ? null : input.openStream();
    }

    public static InputStream openInputStream(File input) throws IOException {
        return input == null ? null : new FileInputStream(input);
    }

    public static InputStream openInputStream(Socket input) throws IOException {
        return input == null ? null : input.getInputStream();
    }
}

