/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.io.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.StringJoiner;

public class FileUtils {
    public static String getFileNameSuffix(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        int dot = (path = FileUtils.getFileName(path)).lastIndexOf(46);
        if (dot >= 0) {
            return path.substring(dot + 1);
        }
        return "";
    }

    public static String getFileName(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        int dot = path.lastIndexOf(47);
        if (dot < 0) {
            dot = path.lastIndexOf(92);
        }
        if (dot < 0) {
            dot = path.lastIndexOf(58);
        }
        if (dot < 0) {
            return path;
        }
        path = path.substring(dot + 1);
        return path;
    }

    public static String readString(Path path) throws IOException {
        return FileUtils.readString(path.toFile(), StandardCharsets.UTF_8);
    }

    public static String readString(Path file, Charset charset) throws IOException {
        return FileUtils.readString(file, charset);
    }

    public static String readString(String path) throws IOException {
        return FileUtils.readString(new File(path), StandardCharsets.UTF_8);
    }

    public static String readString(String file, Charset charset) throws IOException {
        return FileUtils.readString(new File(file), charset);
    }

    public static String readString(File file) throws IOException {
        return FileUtils.readString(file, StandardCharsets.UTF_8);
    }

    public static String readString(File file, Charset charset) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));){
            String s;
            StringJoiner sj = new StringJoiner(System.lineSeparator());
            while ((s = reader.readLine()) != null) {
                sj.add(s);
            }
            String string = sj.toString();
            return string;
        }
    }

    public static void writeString(File file, String content) throws IOException {
        FileUtils.writeString(file, content, StandardCharsets.UTF_8);
    }

    public static void writeString(File file, String content, Charset charset) throws IOException {
        FileUtils.createFileIfNotExist(file);
        Files.write(file.toPath(), Collections.singleton(content), charset, new OpenOption[0]);
    }

    public static byte[] readBytes(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }

    public static void writeBytes(File file, byte[] content) throws IOException {
        FileUtils.createFileIfNotExist(file);
        Files.write(file.toPath(), content, new OpenOption[0]);
    }

    public static File getOrCreateFile(String file) throws IOException {
        File f = new File(file);
        FileUtils.createFileIfNotExist(f);
        return f;
    }

    public static void createFileIfNotExist(File file) throws IOException {
        if (!file.exists()) {
            File p = file.getParentFile();
            FileUtils.createDirIfNotExist(p);
            file.createNewFile();
        }
    }

    public static File getOrCreateDir(String dir) {
        File f = new File(dir);
        FileUtils.createDirIfNotExist(f);
        return f;
    }

    public static void createDirIfNotExist(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static void createDirByFile(File file) {
        if (!file.exists() && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
    }

    public static void createDirByFile(Path file) {
        FileUtils.createDirByFile(file.toFile());
    }
}

