/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.lang;

import java.util.function.Supplier;

public class LazyField<T> {
    private volatile T value;
    private final Supplier<T> supplier;
    private final Object lock = new Object();

    private LazyField(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public static <T> LazyField<T> from(Supplier<T> supplier) {
        return new LazyField<T>(supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        if (this.value == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.value == null) {
                    this.value = this.supplier.get();
                }
            }
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyField<T> set(T value) {
        Object object = this.lock;
        synchronized (object) {
            this.value = value;
        }
        return this;
    }
}

