/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

public class MathUtils {
    public static double toFixed(double value, int scale) {
        return MathUtils.toFixed(value, scale, RoundingMode.HALF_UP);
    }

    public static double toFixed(double value, int scale, RoundingMode roundingMode) {
        return BigDecimal.valueOf(value).setScale(scale, roundingMode).doubleValue();
    }

    public static double toFixed(long value, int scale) {
        return MathUtils.toFixed(value, scale, RoundingMode.HALF_UP);
    }

    public static double toFixed(long value, int scale, RoundingMode roundingMode) {
        return BigDecimal.valueOf(value).setScale(scale, roundingMode).doubleValue();
    }

    public static String toFixedString(double value, int scale) {
        return MathUtils.toFixedString(value, scale, RoundingMode.HALF_UP);
    }

    public static String toFixedString(double value, int scale, RoundingMode roundingMode) {
        return BigDecimal.valueOf(value).setScale(scale, roundingMode).stripTrailingZeros().toPlainString();
    }

    public static String toFixedString(long value, int scale) {
        return MathUtils.toFixedString(value, scale, RoundingMode.HALF_UP);
    }

    public static String toFixedString(long value, int scale, RoundingMode roundingMode) {
        return BigDecimal.valueOf(value).setScale(scale, roundingMode).stripTrailingZeros().toPlainString();
    }

    public static boolean isOdd(int value) {
        return (value & 1) == 1;
    }

    public static long powIntegral(long radix, long power) {
        if (radix == 0L) {
            return 0L;
        }
        if (power < 0L) {
            throw new IllegalArgumentException(radix + "," + power);
        }
        if (power == 0L) {
            return 1L;
        }
        long r = radix;
        while (power > 1L) {
            r *= radix;
            --power;
        }
        return r;
    }

    public static int powIntegral(int radix, int power) {
        if (radix == 0) {
            return 0;
        }
        if (power < 0) {
            throw new IllegalArgumentException(radix + "," + power);
        }
        if (power == 0) {
            return 1;
        }
        int r = radix;
        while (power > 1) {
            r *= radix;
            --power;
        }
        return r;
    }

    public static long powIntegralL(int radix, int power) {
        if (radix == 0) {
            return 0L;
        }
        if (power < 0) {
            throw new IllegalArgumentException(radix + "," + power);
        }
        if (power == 0) {
            return 1L;
        }
        long r = radix;
        while (power > 1) {
            r *= (long)radix;
            --power;
        }
        return r;
    }

    public static List<Integer> findPrimes(int count) {
        ArrayList<Integer> rs = new ArrayList<Integer>(count);
        int num = 2;
        while (rs.size() < count) {
            if (MathUtils.isPrime(num)) {
                rs.add(num);
            }
            ++num;
        }
        return rs;
    }

    public static boolean isPrime(int number) {
        if (number <= 1) {
            return false;
        }
        if (number <= 3) {
            return true;
        }
        if ((number & 1) == 0) {
            return false;
        }
        if (number % 3 == 0) {
            return false;
        }
        int top = (int)Math.sqrt(number);
        if (top * top == number) {
            return false;
        }
        int i = 3;
        for (int j = 5; i <= top && j <= top; i += 2, j += 2) {
            if (number % i != 0 && number % j != 0) continue;
            return false;
        }
        return true;
    }
}

