/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.reflect;

import com.github.azbh111.utils.java.exception.ExceptionUtils;
import com.github.azbh111.utils.java.exception.UnreachableException;
import com.github.azbh111.utils.java.unsafe.UnsafeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ClassUtils {
    private static final Map<Class<?>, Class<?>> primitiveWrapperMap;
    private static final Map<Class<?>, Class<?>> wrapperPrimitiveMap;
    private static final Map<String, String> abbreviationMap;
    private static final Map<String, String> reverseAbbreviationMap;

    public static Class<?> unwrapPrimitive(Class<?> cls) {
        return wrapperPrimitiveMap.get(cls);
    }

    public static Class<?> wrapPrimitive(Class<?> cls) {
        return primitiveWrapperMap.get(cls);
    }

    public static boolean isClassPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            Constructor<T> c = type.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            return c.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException c) {
            try {
                return UnsafeUtils.allocateInstance(type);
            }
            catch (InstantiationException e) {
                ExceptionUtils.throwException(e);
                throw new UnreachableException();
            }
        }
    }

    static {
        HashMap<Class<Object>, Class<Void>> _primitiveWrapperMap = new HashMap<Class<Object>, Class<Void>>();
        _primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        _primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        _primitiveWrapperMap.put(Character.TYPE, Character.class);
        _primitiveWrapperMap.put(Short.TYPE, Short.class);
        _primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        _primitiveWrapperMap.put(Long.TYPE, Long.class);
        _primitiveWrapperMap.put(Double.TYPE, Double.class);
        _primitiveWrapperMap.put(Float.TYPE, Float.class);
        _primitiveWrapperMap.put(Void.TYPE, Void.TYPE);
        primitiveWrapperMap = Collections.unmodifiableMap(_primitiveWrapperMap);
        HashMap _wrapperPrimitiveMap = new HashMap();
        for (Map.Entry<Class<?>, Class<?>> entry : primitiveWrapperMap.entrySet()) {
            Class<?> wrapperClass;
            Class<?> primitiveClass = entry.getKey();
            if (primitiveClass.equals(wrapperClass = entry.getValue())) continue;
            _wrapperPrimitiveMap.put(wrapperClass, primitiveClass);
        }
        wrapperPrimitiveMap = Collections.unmodifiableMap(_wrapperPrimitiveMap);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("int", "I");
        m.put("boolean", "Z");
        m.put("float", "F");
        m.put("long", "J");
        m.put("short", "S");
        m.put("byte", "B");
        m.put("double", "D");
        m.put("char", "C");
        HashMap r = new HashMap();
        for (Map.Entry e : m.entrySet()) {
            r.put(e.getValue(), e.getKey());
        }
        abbreviationMap = Collections.unmodifiableMap(m);
        reverseAbbreviationMap = Collections.unmodifiableMap(r);
    }
}

