/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.reflect;

import com.github.azbh111.utils.java.reflect.model.FieldFilter;
import com.github.azbh111.utils.java.reflect.model.MethodFilter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class ReflectUtils {
    public static Annotation findAnnotation(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType) {
        HashSet<AnnotatedElement> set = new HashSet<AnnotatedElement>();
        return ReflectUtils.findAnnotation(annotatedElement, annotationType, set);
    }

    private static Annotation findAnnotation(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType, Set<AnnotatedElement> container) {
        if (!container.add(annotatedElement)) {
            return null;
        }
        Annotation ann = annotatedElement.getAnnotation(annotationType);
        if (ann != null) {
            return ann;
        }
        for (Annotation annotation : annotatedElement.getAnnotations()) {
            ann = ReflectUtils.findAnnotation(annotation.getClass(), annotationType, container);
            if (ann == null) continue;
            return ann;
        }
        if (annotatedElement instanceof Class) {
            Class type = (Class)annotatedElement;
            ann = ReflectUtils.findAnnotation(type.getSuperclass(), annotationType, container);
            if (ann != null) {
                return ann;
            }
            for (Class<?> aClass : type.getInterfaces()) {
                ann = ReflectUtils.findAnnotation(aClass, annotationType, container);
                if (ann == null) continue;
                return ann;
            }
        }
        return null;
    }

    public static List<Field> getAllFields(Class clazz) {
        return ReflectUtils.getAllFields(clazz, FieldFilter.create());
    }

    public static Field getField(Class clazz, String name) throws NoSuchFieldException {
        return ReflectUtils.getField(clazz, (FieldFilter)FieldFilter.create().setName(name));
    }

    public static Field getField(Class clazz, FieldFilter filter) throws NoSuchFieldException {
        List<Field> list = ReflectUtils.getAllFields(clazz, filter);
        if (list == null || list.isEmpty()) {
            throw new NoSuchFieldException("can not find field in " + clazz.getName() + " with filter:" + String.valueOf(filter));
        }
        if (filter.getIndex() != null) {
            if (filter.getIndex() < list.size()) {
                return list.get(filter.getIndex());
            }
            throw new NoSuchFieldException("can not find field in " + clazz.getName() + " with filter:" + String.valueOf(filter));
        }
        if (list.size() > 1) {
            throw new NoSuchFieldException("find " + list.size() + " fields in " + clazz.getName() + " with filter:" + String.valueOf(filter));
        }
        return list.get(0);
    }

    public static Field getField(Class clazz, Predicate<Field> filter) throws NoSuchFieldException {
        if (filter instanceof FieldFilter) {
            return ReflectUtils.getField(clazz, (FieldFilter)filter);
        }
        List<Field> list = ReflectUtils.getAllFields(clazz, filter);
        if (list == null || list.isEmpty()) {
            throw new NoSuchFieldException("can not find field in " + clazz.getName() + " with filter:" + String.valueOf(filter));
        }
        if (list.size() > 1) {
            throw new NoSuchFieldException("find " + list.size() + " fields in " + clazz.getName() + " with filter:" + String.valueOf(filter));
        }
        return list.get(0);
    }

    public static List<Field> getAllFields(Class clazz, Predicate<Field> filter) {
        if (clazz == null) {
            return new ArrayList<Field>();
        }
        ArrayList<Field> fs = new ArrayList<Field>();
        for (Class now = clazz; now != null && now != Object.class; now = now.getSuperclass()) {
            for (Field field : now.getDeclaredFields()) {
                if (filter != null && !filter.test(field)) continue;
                fs.add(field);
            }
        }
        return fs;
    }

    public static List<Method> getAllMethods(Class clazz) {
        return ReflectUtils.getAllMethods(clazz, MethodFilter.create());
    }

    public static Method getMethod(Class clazz, String name) throws NoSuchMethodException {
        return ReflectUtils.getMethod(clazz, (MethodFilter)MethodFilter.create().setName(name));
    }

    public static Method getMethod(Class clazz, MethodFilter filter) throws NoSuchMethodException {
        List<Method> list = ReflectUtils.getAllMethods(clazz, filter);
        if (list == null || list.isEmpty()) {
            throw new NoSuchMethodException("can not find method in " + clazz.getName() + " with filter:" + String.valueOf(filter));
        }
        if (filter.getIndex() != null) {
            if (filter.getIndex() < list.size()) {
                return list.get(filter.getIndex());
            }
            throw new NoSuchMethodException("can not find method in " + clazz.getName() + " with filter:" + String.valueOf(filter));
        }
        if (list.size() > 1) {
            throw new NoSuchMethodException("find " + list.size() + " methods in " + clazz.getName() + " with filter:" + String.valueOf(filter));
        }
        return list.get(0);
    }

    public static Method getMethod(Class clazz, Predicate<Method> filter) throws NoSuchMethodException {
        if (filter instanceof MethodFilter) {
            return ReflectUtils.getMethod(clazz, (MethodFilter)filter);
        }
        List<Method> list = ReflectUtils.getAllMethods(clazz, filter);
        if (list == null || list.isEmpty()) {
            throw new NoSuchMethodException("can not find method in " + clazz.getName() + " with filter:" + String.valueOf(filter));
        }
        if (list.size() > 1) {
            throw new NoSuchMethodException("find " + list.size() + " methods in " + clazz.getName() + " with filter:" + String.valueOf(filter));
        }
        return list.get(0);
    }

    public static List<Method> getAllMethods(Class clazz, Predicate<Method> filter) {
        ArrayList<Method> fs = new ArrayList<Method>();
        for (Class now = clazz; now != null && now != Object.class; now = now.getSuperclass()) {
            for (Method method : now.getDeclaredMethods()) {
                if (!filter.test(method)) continue;
                fs.add(method);
            }
        }
        return fs;
    }
}

