/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.reflect.model;

import java.lang.reflect.Field;

public class UnsafeField {
    private final long offset;
    private final Field field;
    private final Class type;

    private UnsafeField(Builder builder) {
        this.offset = builder.offset;
        this.field = builder.field;
        this.type = builder.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(UnsafeField copy) {
        Builder builder = new Builder();
        builder.offset = copy.getOffset();
        builder.field = copy.getField();
        builder.type = copy.getType();
        return builder;
    }

    public long getOffset() {
        return this.offset;
    }

    public Field getField() {
        return this.field;
    }

    public Class getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UnsafeField{");
        sb.append("offset=").append(this.offset);
        sb.append(", field=").append(this.field);
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }

    public static final class Builder {
        private long offset;
        private Field field;
        private Class type;

        private Builder() {
        }

        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder field(Field field) {
            this.field = field;
            return this;
        }

        public Builder type(Class type) {
            this.type = type;
            return this;
        }

        public UnsafeField build() {
            return new UnsafeField(this);
        }
    }
}

