/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.string;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.Vector;

public class Tokenizer {
    public static char NO_COMMENT_CHARACTER = '\u0000';
    private Vector _indexToTokenEntries;
    private int _currentIndex = 0;

    public Tokenizer(String str, String delimiter) {
        this(str, new String[]{delimiter});
    }

    public Tokenizer(String str, String[] delimiters) {
        this(str, delimiters, false, false, NO_COMMENT_CHARACTER, NO_COMMENT_CHARACTER);
    }

    public Tokenizer(String str, String[] delimiters, boolean returnDelimiters, boolean returnEmptyStrings, char commentStartCharacter, char commentEndCharacter) {
        StringBuilder buf = new StringBuilder(str);
        TreeMap<Double, String> indexToDelimiterMap = new TreeMap<Double, String>();
        for (int i = 0; i < delimiters.length; ++i) {
            Tokenizer.getDelimiterIndizes(buf, delimiters[i], commentStartCharacter, commentEndCharacter, indexToDelimiterMap);
        }
        TreeMap<Double, String> indexToTokenMap = new TreeMap<Double, String>();
        Tokenizer.getTokenIndizes(buf, indexToDelimiterMap, indexToTokenMap, returnEmptyStrings);
        if (returnDelimiters) {
            indexToTokenMap.putAll(indexToDelimiterMap);
        }
        this._indexToTokenEntries = new Vector();
        this._indexToTokenEntries.addAll(indexToTokenMap.entrySet());
    }

    public boolean hasMoreTokens() {
        return this._currentIndex < this._indexToTokenEntries.size();
    }

    public String nextToken() {
        if (this._currentIndex >= this._indexToTokenEntries.size()) {
            throw new NoSuchElementException();
        }
        Map.Entry entry = (Map.Entry)this._indexToTokenEntries.get(this._currentIndex);
        String returnString = (String)entry.getValue();
        ++this._currentIndex;
        return returnString;
    }

    public int leftTokens() {
        return this._indexToTokenEntries.size() - this._currentIndex;
    }

    private static void getTokenIndizes(StringBuilder buf, TreeMap<Double, String> indexToDelimiterMap, TreeMap<Double, String> tokenMap, boolean returnEmptyStrings) {
        Iterator<Map.Entry<Double, String>> it = indexToDelimiterMap.entrySet().iterator();
        int lastStopIndex = 0;
        while (it.hasNext()) {
            Map.Entry<Double, String> entry = it.next();
            int currentStopIndex = (int)entry.getKey().floatValue();
            Tokenizer.putTokenIfNecessary(buf, tokenMap, returnEmptyStrings, lastStopIndex, currentStopIndex);
            String delimiterString = entry.getValue();
            lastStopIndex = currentStopIndex + delimiterString.length();
        }
        Tokenizer.putTokenIfNecessary(buf, tokenMap, returnEmptyStrings, lastStopIndex, buf.length());
    }

    private static void putTokenIfNecessary(StringBuilder buf, TreeMap<Double, String> tokenMap, boolean returnEmptyStrings, int lastStopIndex, int currentStopIndex) {
        String returnString = buf.substring(lastStopIndex, currentStopIndex);
        if (returnString.trim().equals("")) {
            if (returnEmptyStrings) {
                tokenMap.put(new Double((double)lastStopIndex - 0.5), returnString);
            }
        } else {
            tokenMap.put(new Double(lastStopIndex), returnString);
        }
    }

    private static void getDelimiterIndizes(StringBuilder buf, String delimiter, char commentStartCharacter, char commentEndCharacter, TreeMap<Double, String> indexToDelimiterMap) {
        int delimiterIndex = 0;
        boolean isComment = false;
        if (commentEndCharacter == NO_COMMENT_CHARACTER) {
            commentEndCharacter = commentStartCharacter;
        }
        for (int i = 0; i < buf.length(); ++i) {
            if (buf.charAt(i) == commentStartCharacter && !isComment || buf.charAt(i) == commentEndCharacter && isComment) {
                isComment = !isComment;
                delimiterIndex = 0;
                continue;
            }
            if (isComment) continue;
            if (buf.charAt(i) == delimiter.charAt(delimiterIndex)) {
                if (++delimiterIndex != delimiter.length()) continue;
                int delimiterStartIndex = i - delimiterIndex + 1;
                indexToDelimiterMap.put(new Double(delimiterStartIndex), delimiter);
                delimiterIndex = 0;
                continue;
            }
            delimiterIndex = 0;
        }
    }
}

