/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.uid;

import com.github.azbh111.utils.java.date.DateUtils;
import com.github.azbh111.utils.java.datetime.DateTimeUtils;
import com.github.azbh111.utils.java.uid.BitsAllocator;
import com.github.azbh111.utils.java.uid.UidGenerateException;
import com.github.azbh111.utils.java.uid.UidGenerator;
import java.time.LocalDate;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class DefaultUidGenerator
implements UidGenerator {
    protected long epochSeconds = TimeUnit.MILLISECONDS.toSeconds(1463673600000L);
    protected BitsAllocator bitsAllocator;
    protected long workerId;
    protected long sequence = 0L;
    protected long lastSecond = -1L;

    @Override
    public long getUID() throws UidGenerateException {
        try {
            return this.nextId();
        }
        catch (Exception e) {
            throw new UidGenerateException(e);
        }
    }

    @Override
    public String parseUID(long uid) {
        long totalBits = 64L;
        long signBits = this.bitsAllocator.getSignBits();
        long timestampBits = this.bitsAllocator.getTimestampBits();
        long workerIdBits = this.bitsAllocator.getWorkerIdBits();
        long sequenceBits = this.bitsAllocator.getSequenceBits();
        long sequence = uid << (int)(totalBits - sequenceBits) >>> (int)(totalBits - sequenceBits);
        long workerId = uid << (int)(timestampBits + signBits) >>> (int)(totalBits - workerIdBits);
        long deltaSeconds = uid >>> (int)(workerIdBits + sequenceBits);
        Date thatTime = new Date(TimeUnit.SECONDS.toMillis(this.epochSeconds + deltaSeconds));
        String thatTimeStr = DateTimeUtils.format(thatTime, "yyyy-MM-dd HH:mm:ss");
        return String.format("{\"UID\":\"%d\",\"timestamp\":\"%s\",\"workerId\":\"%d\",\"sequence\":\"%d\"}", uid, thatTimeStr, workerId, sequence);
    }

    protected synchronized long nextId() {
        long currentSecond = this.getCurrentSecond();
        if (currentSecond < this.lastSecond) {
            long refusedSeconds = this.lastSecond - currentSecond;
            throw new UidGenerateException("Clock moved backwards. Refusing for %d seconds", refusedSeconds);
        }
        if (currentSecond == this.lastSecond) {
            this.sequence = this.sequence + 1L & this.bitsAllocator.getMaxSequence();
            if (this.sequence == 0L) {
                currentSecond = this.getNextSecond(this.lastSecond);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastSecond = currentSecond;
        return this.bitsAllocator.allocate(currentSecond - this.epochSeconds, this.workerId, this.sequence);
    }

    private long getNextSecond(long lastTimestamp) {
        long timestamp = this.getCurrentSecond();
        while (timestamp <= lastTimestamp) {
            timestamp = this.getCurrentSecond();
        }
        return timestamp;
    }

    private long getCurrentSecond() {
        long currentSecond = System.currentTimeMillis() / 1000L;
        if (currentSecond - this.epochSeconds > this.bitsAllocator.getMaxDeltaSeconds()) {
            throw new UidGenerateException("Timestamp bits is exhausted. Refusing UID generate. Now: " + currentSecond);
        }
        return currentSecond;
    }

    public static DefaultUidGeneratorBuilder builder() {
        return new DefaultUidGeneratorBuilder();
    }

    public static class DefaultUidGeneratorBuilder {
        private int timeBits = 28;
        private int workerBits = 22;
        private int seqBits = 13;
        private LocalDate epochSecondsStart = LocalDate.of(2020, 1, 1);
        private long workerId;

        public UidGenerator build() {
            DefaultUidGenerator g = new DefaultUidGenerator();
            if (this.timeBits + this.workerBits + this.seqBits > 63) {
                throw new UidGenerateException("bits can not be greater than 63");
            }
            if (this.timeBits + this.workerBits + this.seqBits < 63) {
                this.timeBits = 63 - this.workerBits - this.seqBits;
            }
            g.bitsAllocator = new BitsAllocator(this.timeBits, this.workerBits, this.seqBits);
            g.epochSeconds = DateUtils.toDate(this.epochSecondsStart).getTime() / 1000L;
            g.workerId = this.workerId;
            return g;
        }

        public DefaultUidGeneratorBuilder setMaxWorkers(int maxWorkers) {
            int bits = 1;
            while ((1 << bits) - 1 < maxWorkers) {
                ++bits;
            }
            this.workerBits = bits;
            return this;
        }

        public DefaultUidGeneratorBuilder setMaxIdInSeconds(int maxIds) {
            int bits = 1;
            while ((1 << bits) - 1 < maxIds) {
                ++bits;
            }
            this.seqBits = bits;
            return this;
        }

        public DefaultUidGeneratorBuilder setTimeBits(int timeBits) {
            this.timeBits = timeBits;
            return this;
        }

        public DefaultUidGeneratorBuilder setWorkerBits(int workerBits) {
            this.workerBits = workerBits;
            return this;
        }

        public DefaultUidGeneratorBuilder setSeqBits(int seqBits) {
            this.seqBits = seqBits;
            return this;
        }

        public DefaultUidGeneratorBuilder setEpochSecondsStart(LocalDate epochSecondsStart) {
            this.epochSecondsStart = epochSecondsStart;
            return this;
        }

        public DefaultUidGeneratorBuilder setWorkerId(long workerId) {
            this.workerId = workerId;
            return this;
        }

        public int getTimeBits() {
            return this.timeBits;
        }

        public int getWorkerBits() {
            return this.workerBits;
        }

        public int getSeqBits() {
            return this.seqBits;
        }

        public LocalDate getEpochSecondsStart() {
            return this.epochSecondsStart;
        }

        public long getWorkerId() {
            return this.workerId;
        }
    }
}

