package com.github.azbh111.utils.java.iterable.model;

import java.util.Iterator;
import java.util.function.Function;

/**
 * @author: zyp
 * @since: 2021/7/27 17:51
 */
public class IteratorMapper<K, T> implements Iterator<T> {
    private final Iterator<K> source;
    private Function<K, T> mapper;

    public IteratorMapper(Iterator<K> source, Function<K, T> mapper) {
        if (source == null) {
            this.source = new EmptyIterator<>();
        } else {
            this.source = source;
        }
        this.mapper = mapper;
    }

    @Override
    public boolean hasNext() {
        return source.hasNext();
    }

    @Override
    public T next() {
        return mapper.apply(source.next());
    }
}
