package com.github.azbh111.utils.java.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;

/**
 *
 * @author pyz
 * @date 2019/4/11 9:06 AM
 */
public class ResourceUtils {
    private static final ClassLoader currentClassLoader = ResourceUtils.class.getClassLoader();
    private static final ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();

    public static Enumeration<URL> getResources(Class clazz, String path) throws IOException {
        ClassLoader classLoader;
        classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            return classLoader.getResources(path);
        }
        classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            return classLoader.getResources(path);
        }

        classLoader = currentClassLoader;
        if (classLoader != null) {
            return classLoader.getResources(path);
        }
        classLoader = systemClassLoader;
        if (classLoader != null) {
            return classLoader.getResources(path);
        }
        return Collections.emptyEnumeration();
    }

    public static URL getResource(Class clazz, String path) {
        URL url;
        ClassLoader classLoader;
        classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && classLoader != currentClassLoader && classLoader != systemClassLoader) {
            url = getResource(path, classLoader);
            if (url != null) {
                return url;
            }
        }
        classLoader = clazz.getClassLoader();
        if (classLoader != null && classLoader != currentClassLoader && classLoader != systemClassLoader) {
            url = getResource(path, classLoader);
            if (url != null) {
                return url;
            }
        }

        classLoader = currentClassLoader;
        if (classLoader != null) {
            url = getResource(path, classLoader);
            if (url != null) {
                return url;
            }
        }
        classLoader = systemClassLoader;
        if (classLoader != null) {
            url = getResource(path, classLoader);
            if (url != null) {
                return url;
            }
        }
        return null;
    }


    /**
     *
     *
     * @param path
     * @return
     */
    // 不能在当前类调用
    public static InputStream getResourceAsStream(Class clazz, String path) {
        InputStream is;
        ClassLoader classLoader;
        classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && classLoader != currentClassLoader && classLoader != systemClassLoader) {
            is = getResourceAsStream(path, classLoader);
            if (is != null) {
                return is;
            }
        }
        classLoader = clazz.getClassLoader();
        if (classLoader != null && classLoader != currentClassLoader && classLoader != systemClassLoader) {
            is = getResourceAsStream(path, classLoader);
            if (is != null) {
                return is;
            }
        }

        classLoader = currentClassLoader;
        if (classLoader != null) {
            is = getResourceAsStream(path, classLoader);
            if (is != null) {
                return is;
            }
        }
        classLoader = systemClassLoader;
        if (classLoader != null) {
            is = getResourceAsStream(path, classLoader);
            if (is != null) {
                return is;
            }
        }
        return null;
    }

    private static URL getResource(String path, ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        return classLoader.getResource(path);
    }

    private static InputStream getResourceAsStream(String path, ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        return classLoader.getResourceAsStream(path);
    }
}
