/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.iterable.model;

public class DifferenceView<T> {
    private T leftOnly;
    private T common;
    private T rightOnly;

    DifferenceView(T leftOnly, T common, T rightOnly) {
        this.leftOnly = leftOnly;
        this.common = common;
        this.rightOnly = rightOnly;
    }

    public static <T> DifferenceViewBuilder<T> builder() {
        return new DifferenceViewBuilder();
    }

    public T getLeftOnly() {
        return this.leftOnly;
    }

    public T getCommon() {
        return this.common;
    }

    public T getRightOnly() {
        return this.rightOnly;
    }

    public String toString() {
        return "DifferenceView(leftOnly=" + this.getLeftOnly() + ", common=" + this.getCommon() + ", rightOnly=" + this.getRightOnly() + ")";
    }

    public static class DifferenceViewBuilder<T> {
        private T leftOnly;
        private T common;
        private T rightOnly;

        DifferenceViewBuilder() {
        }

        public DifferenceViewBuilder<T> leftOnly(T leftOnly) {
            this.leftOnly = leftOnly;
            return this;
        }

        public DifferenceViewBuilder<T> common(T common) {
            this.common = common;
            return this;
        }

        public DifferenceViewBuilder<T> rightOnly(T rightOnly) {
            this.rightOnly = rightOnly;
            return this;
        }

        public DifferenceView<T> build() {
            return new DifferenceView<T>(this.leftOnly, this.common, this.rightOnly);
        }

        public String toString() {
            return "DifferenceView.DifferenceViewBuilder(leftOnly=" + this.leftOnly + ", common=" + this.common + ", rightOnly=" + this.rightOnly + ")";
        }
    }
}

