/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.iterable.model;

import com.github.azbh111.utils.java.iterable.model.EmptyIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MergedLazyIterator<T>
implements Iterator<T> {
    private final Iterator<Iterator<T>> sources;
    private Iterator<T> curSource;
    private long limit = Long.MAX_VALUE;
    private long count = 0L;

    public MergedLazyIterator(Iterator<T> ... sources) {
        this.sources = sources == null || sources.length == 0 ? new EmptyIterator<Iterator<T>>() : Arrays.asList(sources).iterator();
    }

    public MergedLazyIterator(Iterator<Iterator<T>> sources) {
        this.sources = sources == null ? new EmptyIterator<Iterator<T>>() : sources;
    }

    private void prepareNext() {
        while (this.curSource == null || !this.curSource.hasNext()) {
            this.closeCurrentSource();
            if (this.sources.hasNext()) {
                this.curSource = this.sources.next();
                continue;
            }
            this.curSource = null;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.count >= this.limit) {
            this.closeCurrentSource();
            return false;
        }
        if (this.curSource != null) {
            if (this.curSource.hasNext()) {
                return true;
            }
            this.closeCurrentSource();
        }
        this.prepareNext();
        return this.curSource != null && this.curSource.hasNext();
    }

    private void closeCurrentSource() {
        if (this.curSource != null && this.curSource instanceof Closeable) {
            try {
                ((Closeable)((Object)this.curSource)).close();
                this.curSource = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public T next() {
        if (this.curSource == null) {
            throw new NoSuchElementException();
        }
        T t = this.curSource.next();
        ++this.count;
        return t;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }
}

