/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.map;

import com.github.azbh111.utils.java.annotation.Nonnull;
import com.github.azbh111.utils.java.annotation.Nullable;
import com.github.azbh111.utils.java.iterable.IterableUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class MapUtils {
    public static <K, V> void putAllIfAbsent(Map<K, V> src, Map<K, V> target) {
        src.forEach((k, v) -> target.putIfAbsent(k, v));
    }

    public static <K, V, T> void putOrCreateAllIfAbsent(Map<K, T> src, Map<K, V> target, BiFunction<K, T, V> generator) {
        src.forEach((k, v) -> target.computeIfAbsent(k, key -> generator.apply(k, v)));
    }

    public static <K, V, GroupKey> Map<GroupKey, Map<K, V>> groupBy(Map<K, V> map, BiFunction<K, V, GroupKey> groupMapper) {
        HashMap resultMap = new HashMap();
        map.forEach((k, v) -> {
            Object key = groupMapper.apply(k, v);
            MapUtils.getOrCreate(resultMap, key, HashMap::new).put(k, v);
        });
        return resultMap;
    }

    public static <K, V, T> List<T> toList(Map<K, V> map, BiFunction<K, V, T> mapper) {
        return map.entrySet().stream().map(entry -> mapper.apply(entry.getKey(), entry.getValue())).collect(Collectors.toList());
    }

    public static <K, V> Map<K, V> extract(Map<K, V> map, Iterable<K> keys) {
        return IterableUtils.toStream(keys, new Iterable[0]).filter(map::containsKey).collect(Collectors.toMap(k -> k, k -> map.get(k)));
    }

    public static <K, V> List<V> extractValueList(Map<K, V> map, Iterable<K> keys) {
        return IterableUtils.toStream(keys, new Iterable[0]).filter(map::containsKey).map(map::get).collect(Collectors.toList());
    }

    public static <K, V> Set<V> extractValueSet(Map<K, V> map, Iterable<K> keys) {
        return IterableUtils.toStream(keys, new Iterable[0]).filter(map::containsKey).map(map::get).collect(Collectors.toSet());
    }

    public static <K, V> V getOrCreate(Map<K, V> map, K key, Supplier<V> valueCreator) {
        V value = map.get(key);
        if (value == null) {
            value = valueCreator.get();
            map.put(key, value);
        }
        return value;
    }

    public static <K, V, T> Map<T, V> computeKey(Map<K, V> src, BiFunction<K, V, T> keyMapper) {
        return MapUtils.compute(src, keyMapper, (k, v) -> v);
    }

    public static <K, V, R> Map<K, R> computeValue(Map<K, V> src, BiFunction<K, V, R> valueMapper) {
        return MapUtils.compute(src, (k, v) -> k, valueMapper);
    }

    public static <K, V, T, R> Map<T, R> compute(Map<K, V> src, BiFunction<K, V, T> keyMapper, BiFunction<K, V, R> valueMapper) {
        HashMap result = new HashMap();
        if (src == null) {
            return result;
        }
        src.forEach((k, v) -> {
            Object replace = result.put(keyMapper.apply(k, v), valueMapper.apply(k, v));
            if (replace != null) {
                throw new IllegalStateException(String.format("Duplicate key %s", k));
            }
        });
        return result;
    }

    public static <K, V> void removeIf(Map<K, V> map, BiPredicate<K, V> test) {
        Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, V> en = it.next();
            if (!test.test(en.getKey(), en.getValue())) continue;
            it.remove();
        }
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, BiPredicate<K, V> test) {
        HashMap result = new HashMap();
        map.forEach((k, v) -> {
            if (test.test(k, v)) {
                result.put(k, v);
            }
        });
        return result;
    }

    public static <K, V> V anyValue(Map<K, V> statusMap) {
        Map.Entry<K, V> entry = MapUtils.anyEntry(statusMap);
        return entry == null ? null : (V)entry.getValue();
    }

    public static <K, V> K anyKey(Map<K, V> statusMap) {
        Map.Entry<K, V> entry = MapUtils.anyEntry(statusMap);
        return entry == null ? null : (K)entry.getKey();
    }

    public static <K, V> Map.Entry<K, V> anyEntry(Map<K, V> statusMap) {
        if (statusMap == null) {
            return null;
        }
        Iterator<Map.Entry<K, V>> it = statusMap.entrySet().iterator();
        if (!it.hasNext()) {
            return null;
        }
        return it.next();
    }

    public static <K, V> boolean isNullOrEmpty(Map<K, V> map) {
        return map == null || map.size() == 0;
    }

    public static <K, V> Map<V, K> reverse(Map<K, V> map) {
        return MapUtils.reverse(map, null);
    }

    public static <K, V> Map<V, K> reverse(@Nonnull Map<K, V> map, @Nullable BinaryOperator<K> mergeFunction) {
        HashMap<V, Object> reverseMap = new HashMap<V, Object>();
        for (Map.Entry<K, V> kvEntry : map.entrySet()) {
            K replaceK = reverseMap.put(kvEntry.getValue(), kvEntry.getKey());
            if (replaceK == null) continue;
            if (mergeFunction == null) {
                throw new IllegalStateException(String.format("Duplicate key %s", kvEntry.getValue()));
            }
            Object finalK = mergeFunction.apply(replaceK, kvEntry.getKey());
            if (finalK == replaceK) continue;
            reverseMap.put(kvEntry.getValue(), finalK);
        }
        return reverseMap;
    }
}

