/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.reflect.model;

import java.lang.annotation.Annotation;
import java.util.function.Predicate;

class CommonFilter<T extends CommonFilter> {
    private String[] prefix;
    private String[] suffix;
    private String[] contains;
    private String[] name;
    private String[] notPrefix;
    private String[] notSuffix;
    private String[] notContains;
    private String[] notNames;
    private Class<? extends Annotation> annotationType;

    CommonFilter() {
    }

    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    public T setAnnotationType(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
        return (T)this;
    }

    public String[] getNotPrefix() {
        return this.notPrefix;
    }

    public T setNotPrefix(String ... notPrefix) {
        this.notPrefix = notPrefix;
        return (T)this;
    }

    public String[] getNotSuffix() {
        return this.notSuffix;
    }

    public T setNotSuffix(String ... notSuffix) {
        this.notSuffix = notSuffix;
        return (T)this;
    }

    public String[] getNotContains() {
        return this.notContains;
    }

    public T setNotContains(String ... notContains) {
        this.notContains = notContains;
        return (T)this;
    }

    public String[] getNotNames() {
        return this.notNames;
    }

    public T setNotNames(String ... notNames) {
        this.notNames = notNames;
        return (T)this;
    }

    public String[] getPrefix() {
        return this.prefix;
    }

    public String[] getSuffix() {
        return this.suffix;
    }

    public String[] getContains() {
        return this.contains;
    }

    public String[] getName() {
        return this.name;
    }

    public T setPrefix(String ... prefix) {
        this.prefix = prefix;
        return (T)this;
    }

    public T setSuffix(String ... suffix) {
        this.suffix = suffix;
        return (T)this;
    }

    public T setContains(String ... contains) {
        this.contains = contains;
        return (T)this;
    }

    public T setName(String ... name) {
        this.name = name;
        return (T)this;
    }

    protected boolean filter(String name) {
        if (this.name != null) {
            return this.match(this.name, s -> name.equals(s));
        }
        if (this.notNames != null && this.match(this.notNames, s -> name.equals(s))) {
            return false;
        }
        if (this.notPrefix != null && this.match(this.notPrefix, s -> name.startsWith((String)s))) {
            return false;
        }
        if (this.notSuffix != null && this.match(this.notSuffix, s -> name.endsWith((String)s))) {
            return false;
        }
        if (this.notContains != null && this.match(this.notContains, s -> name.contains((CharSequence)s))) {
            return false;
        }
        if (!this.match(this.prefix, s -> name.startsWith((String)s))) {
            return false;
        }
        if (!this.match(this.suffix, s -> name.endsWith((String)s))) {
            return false;
        }
        return this.match(this.contains, s -> name.contains((CharSequence)s));
    }

    protected <V> boolean match(V[] value, Predicate<V> predicate) {
        if (value == null) {
            return true;
        }
        for (V v : value) {
            if (!predicate.test(v)) continue;
            return true;
        }
        return false;
    }
}

