/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.rsa;

import com.github.azbh111.utils.java.annotation.Nonnull;
import com.github.azbh111.utils.java.annotation.Nullable;
import com.github.azbh111.utils.java.code.HexUtils;
import com.github.azbh111.utils.java.rsa.RSASignMethodEnum;
import com.github.azbh111.utils.java.rsa.RSAUtils;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSAPair {
    private static final String KEY_ALGORITHM = "RSA";
    private final RSASignMethodEnum signMethod;
    private final byte[] publicKeyBytes;
    private final byte[] privateKeyBytes;
    private final PublicKey publicKey;
    private final PrivateKey privateKey;

    private RSAPair(RSASignMethodEnum signMethod, PublicKey publicKey, PrivateKey privateKey) {
        this.signMethod = signMethod;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.publicKeyBytes = publicKey.getEncoded();
        this.privateKeyBytes = privateKey.getEncoded();
    }

    public static RSAPair create(@Nullable RSASignMethodEnum signMethod, int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGenerator.initialize(keySize);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPublicKey rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        return new RSAPair(signMethod, rsaPublicKey, rsaPrivateKey);
    }

    public static RSAPair create(@Nullable RSASignMethodEnum signMethod, @Nonnull String publicKeyHex, @Nonnull String privateKeyHex) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return new RSAPair(signMethod, RSAUtils.createPublicKey(HexUtils.hexDecode(publicKeyHex)), RSAUtils.createPrivateKey(HexUtils.hexDecode(privateKeyHex)));
    }

    public static RSAPair create(@Nullable RSASignMethodEnum signMethod, @Nonnull byte[] publicKeyBytes, @Nonnull byte[] privateKeyBytes) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return new RSAPair(signMethod, RSAUtils.createPublicKey(publicKeyBytes), RSAUtils.createPrivateKey(privateKeyBytes));
    }

    public static RSAPair create(@Nullable RSASignMethodEnum signMethod, @Nonnull PublicKey publicKey, @Nonnull PrivateKey privateKey) {
        return new RSAPair(signMethod, publicKey, privateKey);
    }

    public byte[] getPublicKeyBytes() {
        return this.publicKeyBytes;
    }

    public byte[] getPrivateKeyBytes() {
        return this.privateKeyBytes;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public byte[] publicEncrypt(byte[] data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return RSAUtils.encrypt(this.publicKey, data);
    }

    public byte[] privateEncrypt(byte[] data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return RSAUtils.encrypt(this.privateKey, data);
    }

    public byte[] publicDencrypt(byte[] data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return RSAUtils.dencrypt(this.publicKey, data);
    }

    public byte[] privateDencrypt(byte[] data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return RSAUtils.dencrypt(this.privateKey, data);
    }

    public byte[] sign(byte[] data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (this.signMethod == null) {
            throw new NoSuchAlgorithmException("signMethod not set");
        }
        return RSAUtils.sign(this.signMethod, this.privateKey, data);
    }

    public boolean verifySign(byte[] data, byte[] sign) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        return RSAUtils.verifySign(this.signMethod, this.publicKey, data, sign);
    }
}

