/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.rsa;

import com.github.azbh111.utils.java.annotation.Nonnull;
import com.github.azbh111.utils.java.annotation.Nullable;
import com.github.azbh111.utils.java.rsa.RSAPair;
import com.github.azbh111.utils.java.rsa.RSASignMethodEnum;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSAUtils {
    static final String KEY_ALGORITHM = "RSA";

    public static RSAPair create(@Nullable RSASignMethodEnum signMethod, int keySize) throws NoSuchAlgorithmException {
        return RSAPair.create(signMethod, keySize);
    }

    public static RSAPair create(@Nullable RSASignMethodEnum signMethod, @Nonnull String publicKeyHex, @Nonnull String privateKeyHex) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return RSAPair.create(signMethod, publicKeyHex, privateKeyHex);
    }

    public static RSAPair create(@Nullable RSASignMethodEnum signMethod, @Nonnull PublicKey publicKey, @Nonnull PrivateKey privateKey) {
        return RSAPair.create(signMethod, publicKey, privateKey);
    }

    public static PrivateKey createPrivateKey(@Nonnull byte[] privateKeyBytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        return keyFactory.generatePrivate(keySpec);
    }

    public static PublicKey createPublicKey(@Nonnull byte[] publicKeyBytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        return keyFactory.generatePublic(keySpec);
    }

    public static byte[] publicEncrypt(@Nonnull byte[] publicKeyBytes, @Nonnull byte[] data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidKeySpecException {
        return RSAUtils.encrypt(RSAUtils.createPublicKey(publicKeyBytes), data);
    }

    public static byte[] privateEncrypt(@Nonnull byte[] privatKeyBytes, @Nonnull byte[] data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidKeySpecException {
        return RSAUtils.encrypt(RSAUtils.createPrivateKey(privatKeyBytes), data);
    }

    public static byte[] publicDencrypt(@Nonnull byte[] publicKeyBytes, @Nonnull byte[] data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidKeySpecException {
        return RSAUtils.dencrypt(RSAUtils.createPublicKey(publicKeyBytes), data);
    }

    public static byte[] privateDencrypt(@Nonnull byte[] privatKeyBytes, @Nonnull byte[] data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidKeySpecException {
        return RSAUtils.dencrypt(RSAUtils.createPrivateKey(privatKeyBytes), data);
    }

    public static byte[] encrypt(@Nonnull Key key, @Nonnull byte[] data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return RSAUtils.doFinal(1, key, data);
    }

    public static byte[] dencrypt(@Nonnull Key key, @Nonnull byte[] data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return RSAUtils.doFinal(2, key, data);
    }

    private static byte[] doFinal(int cipherMode, Key key, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(cipherMode, key);
        return cipher.doFinal(data);
    }

    public static byte[] sign(@Nonnull RSASignMethodEnum signMethod, @Nonnull byte[] privateKeyBytes, @Nonnull byte[] data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidKeySpecException {
        return RSAUtils.sign(signMethod, RSAUtils.createPrivateKey(privateKeyBytes), data);
    }

    public static byte[] sign(@Nonnull RSASignMethodEnum signMethod, @Nonnull PrivateKey privateKey, @Nonnull byte[] data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(signMethod.name());
        signature.initSign(privateKey);
        signature.update(data);
        return signature.sign();
    }

    public static boolean verifySign(@Nonnull RSASignMethodEnum signMethod, @Nonnull byte[] publicKeyBytes, @Nonnull byte[] data, @Nonnull byte[] sign) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidKeySpecException {
        return RSAUtils.verifySign(signMethod, RSAUtils.createPublicKey(publicKeyBytes), data, sign);
    }

    public static boolean verifySign(@Nonnull RSASignMethodEnum signMethod, @Nonnull PublicKey publicKey, @Nonnull byte[] data, @Nonnull byte[] sign) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(signMethod.name());
        signature.initVerify(publicKey);
        signature.update(data);
        return signature.verify(sign);
    }
}

