/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.string;

import com.github.azbh111.utils.java.annotation.Nonnull;
import com.github.azbh111.utils.java.annotation.Nullable;
import com.github.azbh111.utils.java.annotation.Unsafe;
import com.github.azbh111.utils.java.charset.Charsets;
import com.github.azbh111.utils.java.string.model.CollationKeyContainer;
import com.github.azbh111.utils.java.string.model.InpuStreamFromString;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.SharedSecrets;

public class StringUtils {
    public static final List<String> mobilePhonePrefixes = Collections.unmodifiableList(new ArrayList<String>(new HashSet<String>(Arrays.asList("133,149,153,173,177,180,181,189,191,193,199,130,131,132,145,155,156,166,171,175,176,185,186,134,135,136,137,138,139,147,150,151,152,157,158,159,172,178,182,183,184,187,188,195,198,145,147,1700,1701,1702,162,1703,1705,1706,165,1704,1707,1708,1709,171,167,1349,134,135,136,137,138,139,147,150,151,152,157,158,159,1705,178,182,183,184,187,188,198,130,131,132,145,155,156,166,176,1709,171,185,186,133,153,180,181,189,1700,177,173,199".replace("\n", "").split(",")))));
    private static final Pattern mobilePhonePattern = Pattern.compile("^1[0-9]{10}$");
    static final char DBC_CHAR_START = '!';
    static final char DBC_CHAR_END = '~';
    static final char SBC_CHAR_START = '\uff01';
    static final char SBC_CHAR_END = '\uff5e';
    static final int CONVERT_STEP = 65248;
    static final char SBC_SPACE = '\u3000';
    static final char DBC_SPACE = ' ';
    private static final Field stringValue;
    private static final Pattern CHECK_EMOJI;
    private static final byte[] emptyByteArray;

    public static InputStream wrapToInputStream(CharSequence charSequence, Charset charset) {
        if (charSequence == null || charSequence.length() == 0) {
            return new ByteArrayInputStream(emptyByteArray);
        }
        return new InpuStreamFromString(charSequence, charset);
    }

    public static <T> String join(@Nonnull CharSequence separator, @Nonnull Iterable<T> iterable) {
        return StringUtils.join(null, separator, null, iterable, i -> String.valueOf(i));
    }

    public static <T> String join(@Nonnull CharSequence separator, @Nonnull Iterable<T> iterable, @Nonnull Function<T, CharSequence> mapping) {
        return StringUtils.join(null, separator, null, iterable, mapping);
    }

    public static <T> String join(CharSequence prefix, @Nonnull CharSequence separator, CharSequence suffix, @Nonnull Iterable<T> iterable) {
        return StringUtils.join(prefix, separator, suffix, iterable, i -> String.valueOf(i));
    }

    public static <T> String join(CharSequence prefix, @Nonnull CharSequence separator, CharSequence suffix, @Nonnull Iterable<T> iterable, @Nonnull Function<T, CharSequence> mapping) {
        Iterator<T> it;
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        if ((it = iterable.iterator()).hasNext()) {
            sb.append(mapping.apply(it.next()));
        }
        while (it.hasNext()) {
            sb.append(separator).append(mapping.apply(it.next()));
        }
        if (suffix != null) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String reverse(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        int length = str.length();
        char[] chars = new char[length];
        int maxLength = length - 1;
        for (int i = 0; i < length; ++i) {
            chars[i] = str.charAt(maxLength - i);
        }
        return StringUtils.newStringZeroCopy(chars);
    }

    public static String repeat(String str, int times) {
        if (times <= 0) {
            return "";
        }
        if (times == 1) {
            return str;
        }
        if (str == null || str.isEmpty()) {
            return str;
        }
        int length = str.length();
        int destLength = length * times;
        char[] chars = new char[destLength];
        char[] src = StringUtils.getStringValueUnsafe(str);
        for (int i = 0; i < destLength; i += length) {
            System.arraycopy(src, 0, chars, i, length);
        }
        return StringUtils.newStringZeroCopy(chars);
    }

    @Unsafe
    public static char[] getStringValueUnsafe(String str) {
        if (str == null) {
            return null;
        }
        try {
            return (char[])stringValue.get(str);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean containsEmoj(String source) {
        int len = source.length();
        boolean isEmoji = false;
        for (int i = 0; i < len; ++i) {
            char ls;
            char hs = source.charAt(i);
            if ('\ud800' <= hs && hs <= '\udbff') {
                int uc;
                if (source.length() <= 1 || 118784 > (uc = (hs - 55296) * 1024 + ((ls = source.charAt(i + 1)) - 56320) + 65536) || uc > 128895) continue;
                return true;
            }
            if ('\u2100' <= hs && hs <= '\u27ff' && hs != '\u263b') {
                return true;
            }
            if ('\u2b05' <= hs && hs <= '\u2b07') {
                return true;
            }
            if ('\u2934' <= hs && hs <= '\u2935') {
                return true;
            }
            if ('\u3297' <= hs && hs <= '\u3299') {
                return true;
            }
            if (hs == '\u00a9' || hs == '\u00ae' || hs == '\u303d' || hs == '\u3030' || hs == '\u2b55' || hs == '\u2b1c' || hs == '\u2b1b' || hs == '\u2b50' || hs == '\u231a') {
                return true;
            }
            if (isEmoji || source.length() <= 1 || i >= source.length() - 1 || (ls = source.charAt(i + 1)) != '\u20e3') continue;
            return true;
        }
        return isEmoji;
    }

    public static boolean isEmojiCharacter(char codePoint) {
        return !(codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd' || codePoint >= '\u10000' && codePoint <= '\u10ffff');
    }

    public static String removeEmoji(@Nullable String source) {
        if (source == null || source.isEmpty()) {
            return source;
        }
        StringBuilder buf = null;
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char codePoint = source.charAt(i);
            if (StringUtils.isEmojiCharacter(codePoint)) continue;
            if (buf == null) {
                buf = new StringBuilder(source.length());
            }
            buf.append(codePoint);
        }
        if (buf == null) {
            return source;
        }
        if (buf.length() == len) {
            return source;
        }
        return buf.toString();
    }

    public static String trimToNull(@Nullable String src) {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if ((src = src.trim()).isEmpty()) {
            return null;
        }
        return src;
    }

    public static String trimToEmpty(@Nullable String src) {
        if (src == null || src.isEmpty()) {
            return "";
        }
        if ((src = src.trim()).isEmpty()) {
            return "";
        }
        return src;
    }

    public static String hafl2Full(@Nullable String src) {
        if (src == null) {
            return src;
        }
        StringBuilder buf = new StringBuilder(src.length());
        char[] ca = src.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i] == ' ') {
                buf.append('\u3000');
                continue;
            }
            if (ca[i] >= '!' && ca[i] <= '~') {
                buf.append((char)(ca[i] + 65248));
                continue;
            }
            buf.append(ca[i]);
        }
        return buf.toString();
    }

    public static String full2Half(@Nullable String src) {
        if (src == null) {
            return src;
        }
        StringBuilder buf = new StringBuilder(src.length());
        char[] ca = src.toCharArray();
        for (int i = 0; i < src.length(); ++i) {
            if (ca[i] >= '\uff01' && ca[i] <= '\uff5e') {
                buf.append((char)(ca[i] - 65248));
                continue;
            }
            if (ca[i] == '\u3000') {
                buf.append(' ');
                continue;
            }
            buf.append(ca[i]);
        }
        return buf.toString();
    }

    public static boolean isMobilePhone(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        if (str.length() != 11) {
            return false;
        }
        for (String phonePrefix : mobilePhonePrefixes) {
            if (str.startsWith(phonePrefix)) continue;
            return false;
        }
        Matcher m = mobilePhonePattern.matcher(str);
        return m.matches();
    }

    public static int ansiCharCount(@Nullable CharSequence str) {
        int count = 0;
        if (str == null) {
            return count;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            count += Character.charCount(Character.codePointAt(str, i));
        }
        return count;
    }

    public static String upperCaseFirstCharacter(@Nullable String str) {
        return StringUtils.changeFirstLetter(str, 1);
    }

    public static String lowerCaseFirstCharacter(@Nullable String str) {
        return StringUtils.changeFirstLetter(str, -1);
    }

    public static void sortNature(@Nullable List<String> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        StringUtils.sortNature(list, Collator.getInstance(Locale.CHINA));
    }

    public static void sortNature(@Nullable List<String> list, @Nonnull Collator comparetor) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Object[] keys = new CollationKey[list.size()];
        int index = 0;
        for (String str : list) {
            keys[index++] = comparetor.getCollationKey(str);
        }
        Arrays.sort(keys);
        ListIterator<String> it = list.listIterator();
        for (Object key : keys) {
            it.next();
            it.set(((CollationKey)key).getSourceString());
        }
    }

    public static <T> void sortNature(@Nullable List<T> list, @Nonnull Function<T, String> keyMapper) {
        StringUtils.sortNature(list, Collator.getInstance(Locale.CHINA), keyMapper);
    }

    public static <T> void sortNature(@Nullable List<T> list, @Nonnull Collator collator, @Nonnull Function<T, String> keyMapper) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Object[] keys = new CollationKeyContainer[list.size()];
        int index = 0;
        for (T t : list) {
            keys[index++] = new CollationKeyContainer<T>(collator.getCollationKey(keyMapper.apply(t)), t);
        }
        Arrays.sort(keys);
        ListIterator<T> it = list.listIterator();
        for (Object key : keys) {
            it.next();
            it.set(((CollationKeyContainer)key).getExtend());
        }
    }

    public static boolean isEmpty(@Nullable CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(@Nullable CharSequence str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isBlank(@Nullable CharSequence str) {
        return str == null || str.length() == 0 || !StringUtils.containsText(str);
    }

    public static boolean isNotBlank(@Nullable CharSequence str) {
        return !StringUtils.isBlank(str);
    }

    public static String center(String content, char character, int length) {
        return StringUtils.center(content, character, character, length);
    }

    public static String center(String content, char prefix, char suffix, int length) {
        int i;
        if (content == null) {
            return content;
        }
        if (content.length() >= length) {
            return content;
        }
        char[] chars = new char[length];
        int center = content.length();
        int right = (length - center) / 2;
        int left = length - center - right;
        for (i = 0; i < left; ++i) {
            chars[i] = prefix;
        }
        for (i = 0; i < right; ++i) {
            chars[chars.length - right + i] = suffix;
        }
        for (i = 0; i < center; ++i) {
            chars[left + i] = content.charAt(i);
        }
        return StringUtils.newStringZeroCopy(chars);
    }

    @Unsafe
    public static String newStringZeroCopy(char[] bytes) {
        return SharedSecrets.getJavaLangAccess().newStringUnsafe(bytes);
    }

    public static String toString(InputStream stream) throws IOException {
        return StringUtils.toString(stream, Charsets.UTF_8);
    }

    public static String toString(InputStream stream, Charset charset) throws IOException {
        StringBuilder sb = new StringBuilder();
        char[] chars = new char[128];
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
        int n = -1;
        while ((n = reader.read(chars)) != -1) {
            sb.append(chars, 0, n);
        }
        return sb.toString();
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static String changeFirstLetter(String str, int flag) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        char[] chars = str.toCharArray();
        if (flag == 1) {
            chars[0] = Character.toUpperCase(chars[0]);
        } else if (flag == -1) {
            chars[0] = Character.toLowerCase(chars[0]);
        }
        String r = StringUtils.newStringZeroCopy(chars);
        return r;
    }

    static {
        CHECK_EMOJI = Pattern.compile("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]", 66);
        emptyByteArray = new byte[0];
        Field _stringValue = null;
        try {
            _stringValue = String.class.getDeclaredField("value");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        _stringValue.setAccessible(true);
        stringValue = _stringValue;
    }
}

