/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.string.model;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Objects;

public class CharSequenceReader
extends Reader {
    private CharSequence seq;
    private int pos;
    private int mark;

    public CharSequenceReader(CharSequence seq) {
        this.seq = Objects.requireNonNull(seq);
    }

    private boolean hasRemaining() {
        return this.remaining() > 0;
    }

    private int remaining() {
        return this.seq.length() - this.pos;
    }

    @Override
    public synchronized int read(CharBuffer target) throws IOException {
        if (!this.hasRemaining()) {
            return -1;
        }
        int c = Math.min(target.remaining(), this.remaining());
        for (int i = 0; i < c; ++i) {
            target.put(this.seq.charAt(this.pos++));
        }
        return c;
    }

    @Override
    public synchronized int read() throws IOException {
        return this.hasRemaining() ? (int)this.seq.charAt(this.pos++) : -1;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (!this.hasRemaining()) {
            return -1;
        }
        int c = Math.min(len, this.remaining());
        for (int i = 0; i < c; ++i) {
            cbuf[off + i] = this.seq.charAt(this.pos++);
        }
        return c;
    }

    @Override
    public long skip(long n) throws IOException {
        int skip = (int)Math.min((long)this.remaining(), n);
        this.pos += skip;
        return skip;
    }

    @Override
    public boolean ready() throws IOException {
        return true;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.mark = this.pos;
    }

    @Override
    public void reset() throws IOException {
        this.pos = this.mark;
    }

    @Override
    public void close() throws IOException {
    }
}

