/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.string.model;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class InpuStreamFromString
extends InputStream {
    private final CharSequence charSequence;
    private int pos;
    private Charset charset;
    private int maxBytesPerChar;
    private CharsetEncoder charsetEncoder;
    private CharBuffer charBuffer;
    private ByteBuffer byteBuffer;
    private boolean flush;

    public InpuStreamFromString(CharSequence charSequence, Charset charset) {
        this.charSequence = charSequence;
        this.charset = charset;
        this.charsetEncoder = charset.newEncoder();
        this.charBuffer = CharBuffer.allocate(2);
        this.maxBytesPerChar = (int)Math.ceil(this.charsetEncoder.maxBytesPerChar());
        this.byteBuffer = ByteBuffer.allocate(this.maxBytesPerChar << 1);
        this.byteBuffer.flip();
    }

    private boolean decodeOneChar() throws IOException {
        char char2;
        if (this.pos >= this.charSequence.length()) {
            if (!this.flush) {
                this.charsetEncoder.flush(this.byteBuffer);
                this.byteBuffer.flip();
                this.flush = true;
                return true;
            }
            return false;
        }
        char char1 = this.charSequence.charAt(this.pos++);
        this.charBuffer.put(char1);
        if (Character.isHighSurrogate(char1) && Character.isLowSurrogate(char2 = this.charSequence.charAt(this.pos))) {
            this.charBuffer.put(char2);
            ++this.pos;
        }
        this.charBuffer.flip();
        this.charsetEncoder.encode(this.charBuffer, this.byteBuffer, true);
        this.charBuffer.clear();
        this.byteBuffer.flip();
        return true;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        if (len <= 0) {
            return 0;
        }
        for (read = 0; len > read; read += this.readBuffer(this.byteBuffer, b, off + read, len - read)) {
            if (this.byteBuffer.hasRemaining()) break;
            this.byteBuffer.clear();
            if (this.decodeOneChar()) continue;
            this.byteBuffer.flip();
            return read == 0 ? -1 : read;
        }
        return read;
    }

    private int readBuffer(ByteBuffer buf, byte[] b, int off, int len) {
        int leftLen;
        int readLen = leftLen = Math.min(buf.remaining(), len);
        while (leftLen-- > 0) {
            b[off++] = buf.get();
        }
        return readLen;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("skip not support\u0192ed");
    }

    @Override
    public int read() throws IOException {
        if (this.byteBuffer.hasRemaining()) {
            return this.byteBuffer.get();
        }
        this.byteBuffer.clear();
        if (!this.decodeOneChar()) {
            return -1;
        }
        return this.byteBuffer.get();
    }
}

