package com.github.azbh111.utils.java.array;

import com.github.azbh111.utils.java.reflect.ClassUtils;

/**
 * @author pyz
 * @date 2019/4/14 9:59 AM
 */
public class ArrayUtils {

    /**
     * An empty immutable {@code Object} array.
     */
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    /**
     * An empty immutable {@code Class} array.
     */
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    /**
     * An empty immutable {@code String} array.
     */
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    /**
     * An empty immutable {@code long} array.
     */
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    /**
     * An empty immutable {@code Long} array.
     */
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    /**
     * An empty immutable {@code int} array.
     */
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    /**
     * An empty immutable {@code Integer} array.
     */
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    /**
     * An empty immutable {@code short} array.
     */
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    /**
     * An empty immutable {@code Short} array.
     */
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    /**
     * An empty immutable {@code byte} array.
     */
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    /**
     * An empty immutable {@code Byte} array.
     */
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    /**
     * An empty immutable {@code double} array.
     */
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    /**
     * An empty immutable {@code Double} array.
     */
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    /**
     * An empty immutable {@code float} array.
     */
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    /**
     * An empty immutable {@code Float} array.
     */
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    /**
     * An empty immutable {@code boolean} array.
     */
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    /**
     * An empty immutable {@code Boolean} array.
     */
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    /**
     * An empty immutable {@code char} array.
     */
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    /**
     * An empty immutable {@code Character} array.
     */
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];

    public static int indexOf(final boolean[] array, final boolean valueToFind) {
        return indexOf(array, valueToFind, 0, Integer.MAX_VALUE);
    }

    /**
     * @param array
     * @param valueToFind
     * @param startIndex  include
     * @param toIndex     not include
     * @return
     */
    public static int indexOf(final boolean[] array, final boolean valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        for (int i = startIndex; i < toIndex; i++) {
            if (valueToFind == array[i]) {
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(final boolean[] array, final boolean valueToFind) {
        return lastIndexOf(array, valueToFind, Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    /**
     * @param array
     * @param valueToFind
     * @param startIndex  include
     * @param toIndex     not include
     * @return
     */
    public static int lastIndexOf(final boolean[] array, final boolean valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        for (int i = startIndex; i > toIndex; i--) {
            if (valueToFind == array[i]) {
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(final char[] array, final char valueToFind) {
        return indexOf(array, valueToFind, 0, Integer.MAX_VALUE);
    }

    /**
     * @param array
     * @param valueToFind
     * @param startIndex  include
     * @param toIndex     not include
     * @return
     */
    public static int indexOf(final char[] array, final char valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        for (int i = startIndex; i < toIndex; i++) {
            if (valueToFind == array[i]) {
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(final char[] array, final char valueToFind) {
        return lastIndexOf(array, valueToFind, Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    /**
     * @param array
     * @param valueToFind
     * @param startIndex  include
     * @param toIndex     not include
     * @return
     */
    public static int lastIndexOf(final char[] array, final char valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        for (int i = startIndex; i > toIndex; i--) {
            if (valueToFind == array[i]) {
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(final byte[] array, final byte valueToFind) {
        return indexOf(array, valueToFind, 0, Integer.MAX_VALUE);
    }

    /**
     * @param array
     * @param valueToFind
     * @param startIndex  include
     * @param toIndex     not include
     * @return
     */
    public static int indexOf(final byte[] array, final byte valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        for (int i = startIndex; i < toIndex; i++) {
            if (valueToFind == array[i]) {
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(final byte[] array, final byte valueToFind) {
        return lastIndexOf(array, valueToFind, Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    /**
     * @param array
     * @param valueToFind
     * @param startIndex  include
     * @param toIndex     not include
     * @return
     */
    public static int lastIndexOf(final byte[] array, final byte valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        for (int i = startIndex; i > toIndex; i--) {
            if (valueToFind == array[i]) {
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(final short[] array, final short valueToFind) {
        return indexOf(array, valueToFind, 0, Integer.MAX_VALUE);
    }

    /**
     * @param array
     * @param valueToFind
     * @param startIndex  include
     * @param toIndex     not include
     * @return
     */
    public static int indexOf(final short[] array, final short valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        for (int i = startIndex; i < toIndex; i++) {
            if (valueToFind == array[i]) {
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(final short[] array, final short valueToFind) {
        return lastIndexOf(array, valueToFind, Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    /**
     * @param array
     * @param valueToFind
     * @param startIndex  include
     * @param toIndex     not include
     * @return
     */
    public static int lastIndexOf(final short[] array, final short valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        for (int i = startIndex; i > toIndex; i--) {
            if (valueToFind == array[i]) {
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(final int[] array, final int valueToFind) {
        return indexOf(array, valueToFind, 0, Integer.MAX_VALUE);
    }

    /**
     * @param array
     * @param valueToFind
     * @param startIndex  include
     * @param toIndex     not include
     * @return
     */
    public static int indexOf(final int[] array, final int valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        for (int i = startIndex; i < toIndex; i++) {
            if (valueToFind == array[i]) {
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(final int[] array, final int valueToFind) {
        return lastIndexOf(array, valueToFind, Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    /**
     * @param array
     * @param valueToFind
     * @param startIndex  include
     * @param toIndex     not include
     * @return
     */
    public static int lastIndexOf(final int[] array, final int valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        for (int i = startIndex; i > toIndex; i--) {
            if (valueToFind == array[i]) {
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(final long[] array, final long valueToFind) {
        return indexOf(array, valueToFind, 0, Integer.MAX_VALUE);
    }

    /**
     * @param array
     * @param valueToFind
     * @param startIndex  include
     * @param toIndex     not include
     * @return
     */
    public static int indexOf(final long[] array, final long valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        for (int i = startIndex; i < toIndex; i++) {
            if (valueToFind == array[i]) {
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(final long[] array, final long valueToFind) {
        return lastIndexOf(array, valueToFind, Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    /**
     * @param array
     * @param valueToFind
     * @param startIndex  include
     * @param toIndex     not include
     * @return
     */
    public static int lastIndexOf(final long[] array, final long valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        for (int i = startIndex; i > toIndex; i--) {
            if (valueToFind == array[i]) {
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(final float[] array, final float valueToFind) {
        return indexOf(array, valueToFind, 0, Integer.MAX_VALUE);
    }

    /**
     * @param array
     * @param valueToFind
     * @param startIndex  include
     * @param toIndex     not include
     * @return
     */
    public static int indexOf(final float[] array, final float valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        for (int i = startIndex; i < toIndex; i++) {
            if (valueToFind == array[i]) {
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(final float[] array, final float valueToFind) {
        return lastIndexOf(array, valueToFind, Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    /**
     * @param array
     * @param valueToFind
     * @param startIndex  include
     * @param toIndex     not include
     * @return
     */
    public static int lastIndexOf(final float[] array, final float valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        for (int i = startIndex; i > toIndex; i--) {
            if (valueToFind == array[i]) {
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(final double[] array, final double valueToFind) {
        return indexOf(array, valueToFind, 0, Integer.MAX_VALUE);
    }

    /**
     * @param array
     * @param valueToFind
     * @param startIndex  include
     * @param toIndex     not include
     * @return
     */
    public static int indexOf(final double[] array, final double valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        for (int i = startIndex; i < toIndex; i++) {
            if (valueToFind == array[i]) {
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(final double[] array, final double valueToFind) {
        return lastIndexOf(array, valueToFind, Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    /**
     * @param array
     * @param valueToFind
     * @param startIndex  include
     * @param toIndex     not include
     * @return
     */
    public static int lastIndexOf(final double[] array, final double valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        for (int i = startIndex; i > toIndex; i--) {
            if (valueToFind == array[i]) {
                return i;
            }
        }
        return -1;
    }

    /**
     * @param array
     * @param valueToFind
     * @param tolerance   精度
     * @return
     */
    public static int indexOf(final double[] array, final double valueToFind, final double tolerance) {
        return indexOf(array, valueToFind, 0, Integer.MAX_VALUE, tolerance);
    }

    /**
     * @param array
     * @param valueToFind
     * @param startIndex  include
     * @param toIndex     not include
     * @param tolerance   精度
     * @return
     */
    public static int indexOf(final double[] array, final double valueToFind, int startIndex, int toIndex, final double tolerance) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex >= array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        final double min = valueToFind - tolerance;
        final double max = valueToFind + tolerance;
        for (int i = startIndex; i < toIndex; i++) {
            if (array[i] >= min && array[i] <= max) {
                return i;
            }
        }
        return -1;
    }

    /**
     * @param array
     * @param valueToFind
     * @param tolerance   精度
     * @return
     */
    public static int lastIndexOf(final double[] array, final double valueToFind, final double tolerance) {
        return lastIndexOf(array, valueToFind, Integer.MAX_VALUE, Integer.MIN_VALUE, tolerance);
    }

    /**
     * @param array
     * @param valueToFind
     * @param startIndex  include
     * @param toIndex     not include
     * @param tolerance   精度
     * @return
     */
    public static int lastIndexOf(final double[] array, final double valueToFind, int startIndex, int toIndex, final double tolerance) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        final double min = valueToFind - tolerance;
        final double max = valueToFind + tolerance;
        for (int i = startIndex; i > toIndex; i--) {
            if (array[i] >= min && array[i] <= max) {
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(final Object[] array, final Object objectToFind) {
        return indexOf(array, objectToFind, 0, Integer.MAX_VALUE);
    }

    /**
     * @param array
     * @param objectToFind
     * @param startIndex   include
     * @param toIndex      not include
     * @return
     */
    public static int indexOf(final Object[] array, final Object objectToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex >= array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i < toIndex; i++) {
                if (array[i] == null) {
                    return i;
                }
            }
        } else {
            for (int i = startIndex; i < toIndex; i++) {
                if (objectToFind.equals(array[i])) {
                    return i;
                }
            }
        }
        return -1;
    }

    public static int lastIndexOf(final Object[] array, final Object objectToFind) {
        return lastIndexOf(array, objectToFind, Integer.MAX_VALUE, -1);
    }

    /**
     * @param array
     * @param objectToFind
     * @param startIndex   include
     * @param toIndex      not include
     * @return
     */
    public static int lastIndexOf(final Object[] array, final Object objectToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i > toIndex; i--) {
                if (array[i] == null) {
                    return i;
                }
            }
        } else if (array.getClass().getComponentType().isInstance(objectToFind)) {
            for (int i = startIndex; i > toIndex; i--) {
                if (objectToFind.equals(array[i])) {
                    return i;
                }
            }
        }
        return -1;
    }

    public static Boolean[] wrap(final boolean[] array) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        final Boolean[] result = new Boolean[array.length];
        for (int i = 0; i < array.length; i++) {
            result[i] = (array[i] ? Boolean.TRUE : Boolean.FALSE);
        }
        return result;
    }

    public static Character[] wrap(final char[] array) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        final Character[] result = new Character[array.length];
        for (int i = 0; i < array.length; i++) {
            result[i] = array[i];
        }
        return result;
    }

    public static Byte[] wrap(final byte[] array) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        final Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; i++) {
            result[i] = Byte.valueOf(array[i]);
        }
        return result;
    }

    public static Short[] wrap(final short[] array) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        final Short[] result = new Short[array.length];
        for (int i = 0; i < array.length; i++) {
            result[i] = Short.valueOf(array[i]);
        }
        return result;
    }

    public static Integer[] wrap(final int[] array) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        final Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; i++) {
            result[i] = Integer.valueOf(array[i]);
        }
        return result;
    }

    public static Long[] wrap(final long[] array) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        final Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; i++) {
            result[i] = Long.valueOf(array[i]);
        }
        return result;
    }

    public static Float[] wrap(final float[] array) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        final Float[] result = new Float[array.length];
        for (int i = 0; i < array.length; i++) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    public static Double[] wrap(final double[] array) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        final Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; i++) {
            result[i] = Double.valueOf(array[i]);
        }
        return result;
    }

    public static boolean[] unwrap(final Boolean[] array) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        final boolean[] result = new boolean[array.length];
        for (int i = 0; i < array.length; i++) {
            result[i] = array[i].booleanValue();
        }
        return result;
    }

    public static boolean[] unwrap(final Boolean[] array, final boolean valueForNull) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        final boolean[] result = new boolean[array.length];
        for (int i = 0; i < array.length; i++) {
            final Boolean b = array[i];
            result[i] = (b == null ? valueForNull : b.booleanValue());
        }
        return result;
    }

    public static char[] unwrap(final Character[] array) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        final char[] result = new char[array.length];
        for (int i = 0; i < array.length; i++) {
            result[i] = array[i].charValue();
        }
        return result;
    }

    public static char[] unwrap(final Character[] array, final char valueForNull) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        final char[] result = new char[array.length];
        for (int i = 0; i < array.length; i++) {
            final Character b = array[i];
            result[i] = (b == null ? valueForNull : b.charValue());
        }
        return result;
    }

    public static byte[] unwrap(final Byte[] array) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        final byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; i++) {
            result[i] = array[i].byteValue();
        }
        return result;
    }

    public static byte[] unwrap(final Byte[] array, final byte valueForNull) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        final byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; i++) {
            final Byte b = array[i];
            result[i] = (b == null ? valueForNull : b.byteValue());
        }
        return result;
    }

    public static short[] unwrap(final Short[] array, final short valueForNull) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        final short[] result = new short[array.length];
        for (int i = 0; i < array.length; i++) {
            final Short b = array[i];
            result[i] = (b == null ? valueForNull : b.shortValue());
        }
        return result;
    }

    public static short[] unwrap(final Short[] array) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        final short[] result = new short[array.length];
        for (int i = 0; i < array.length; i++) {
            result[i] = array[i].shortValue();
        }
        return result;
    }

    public static int[] unwrap(final Integer[] array) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        final int[] result = new int[array.length];
        for (int i = 0; i < array.length; i++) {
            result[i] = array[i].intValue();
        }
        return result;
    }

    public static int[] unwrap(final Integer[] array, final int valueForNull) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        final int[] result = new int[array.length];
        for (int i = 0; i < array.length; i++) {
            final Integer b = array[i];
            result[i] = (b == null ? valueForNull : b.intValue());
        }
        return result;
    }

    public static long[] unwrap(final Long[] array) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        final long[] result = new long[array.length];
        for (int i = 0; i < array.length; i++) {
            result[i] = array[i].longValue();
        }
        return result;
    }

    public static long[] unwrap(final Long[] array, final long valueForNull) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        final long[] result = new long[array.length];
        for (int i = 0; i < array.length; i++) {
            final Long b = array[i];
            result[i] = (b == null ? valueForNull : b.longValue());
        }
        return result;
    }

    public static float[] unwrap(final Float[] array) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        final float[] result = new float[array.length];
        for (int i = 0; i < array.length; i++) {
            result[i] = array[i].floatValue();
        }
        return result;
    }

    public static float[] unwrap(final Float[] array, final float valueForNull) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        final float[] result = new float[array.length];
        for (int i = 0; i < array.length; i++) {
            final Float b = array[i];
            result[i] = (b == null ? valueForNull : b.floatValue());
        }
        return result;
    }

    public static double[] unwrap(final Double[] array) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        final double[] result = new double[array.length];
        for (int i = 0; i < array.length; i++) {
            result[i] = array[i].doubleValue();
        }
        return result;
    }

    public static double[] unwrap(final Double[] array, final double valueForNull) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        final double[] result = new double[array.length];
        for (int i = 0; i < array.length; i++) {
            final Double b = array[i];
            result[i] = (b == null ? valueForNull : b.doubleValue());
        }
        return result;
    }

    /**
     * 通用解包方法
     * 若arr不是包装类型数组,返回null
     *
     * @param array
     * @return
     */
    public static Object unwrapArray(final Object array) {
        if (array == null) {
            return null;
        }
        final Class<?> ct = array.getClass().getComponentType();
        final Class<?> pt = ClassUtils.unwrapPrimitive(ct);
        if (pt == null) {
            return null;
        }
        if (pt == Boolean.TYPE) {
            return unwrap((Boolean[]) array);
        }
        if (pt == Character.TYPE) {
            return unwrap((Character[]) array);
        }
        if (pt == Byte.TYPE) {
            return unwrap((Byte[]) array);
        }
        if (pt == Short.TYPE) {
            return unwrap((Short[]) array);
        }
        if (pt == Integer.TYPE) {
            return unwrap((Integer[]) array);
        }
        if (pt == Long.TYPE) {
            return unwrap((Long[]) array);
        }
        if (pt == Float.TYPE) {
            return unwrap((Float[]) array);
        }
        if (pt == Double.TYPE) {
            return unwrap((Double[]) array);
        }
        return null;
    }

    /**
     * 通用包装方法
     * 若arr不是基本数据类型数组,返回null
     *
     * @param array
     * @return
     */
    public static Object wrapArray(final Object array) {
        if (array == null) {
            return null;
        }
        final Class<?> pt = array.getClass().getComponentType();
        if (!pt.isPrimitive()) {
            return null;
        }
        if (pt == boolean.class) {
            return wrap((boolean[]) array);
        }
        if (pt == char.class) {
            return wrap((char[]) array);
        }
        if (pt == byte.class) {
            return wrap((byte[]) array);
        }
        if (pt == short.class) {
            return wrap((short[]) array);
        }
        if (pt == int.class) {
            return wrap((int[]) array);
        }
        if (pt == long.class) {
            return wrap((long[]) array);
        }
        if (pt == float.class) {
            return wrap((float[]) array);
        }
        if (pt == double.class) {
            return wrap((double[]) array);
        }
        return null;
    }

    public static int indexOfMaxValue(int[] arr) {
        return indexOfMaxValue(arr, 0, arr.length);
    }

    /**
     * 在[fromIndex,toIndex)范围内查找最大元素的index
     *
     * @param arr
     * @param fromIndex
     * @param toIndex
     * @return
     */
    public static int indexOfMaxValue(int[] arr, int fromIndex, int toIndex) {
        int maxIndex = -1;
        int maxValue = Integer.MIN_VALUE;
        for (int i = fromIndex; i < toIndex; i++) {
            if (maxValue < arr[i]) {
                maxValue = arr[i];
                maxIndex = i;
            }
        }
        return maxIndex;
    }

    public static void swap(byte[] arr, int leftIndex, int rightIndex) {
        byte tmp = arr[leftIndex];
        arr[leftIndex] = arr[rightIndex];
        arr[rightIndex] = tmp;
    }


    public static void swap(short[] arr, int leftIndex, int rightIndex) {
        short tmp = arr[leftIndex];
        arr[leftIndex] = arr[rightIndex];
        arr[rightIndex] = tmp;
    }

    public static void swap(int[] arr, int leftIndex, int rightIndex) {
        int tmp = arr[leftIndex];
        arr[leftIndex] = arr[rightIndex];
        arr[rightIndex] = tmp;
    }


    public static void swap(long[] arr, int leftIndex, int rightIndex) {
        long tmp = arr[leftIndex];
        arr[leftIndex] = arr[rightIndex];
        arr[rightIndex] = tmp;
    }

    public static void swap(float[] arr, int leftIndex, int rightIndex) {
        float tmp = arr[leftIndex];
        arr[leftIndex] = arr[rightIndex];
        arr[rightIndex] = tmp;
    }


    public static void swap(double[] arr, int leftIndex, int rightIndex) {
        double tmp = arr[leftIndex];
        arr[leftIndex] = arr[rightIndex];
        arr[rightIndex] = tmp;
    }


    public static void swap(boolean[] arr, int leftIndex, int rightIndex) {
        boolean tmp = arr[leftIndex];
        arr[leftIndex] = arr[rightIndex];
        arr[rightIndex] = tmp;
    }


    public static void swap(char[] arr, int leftIndex, int rightIndex) {
        char tmp = arr[leftIndex];
        arr[leftIndex] = arr[rightIndex];
        arr[rightIndex] = tmp;
    }

    public static <T> void swap(T[] arr, int leftIndex, int rightIndex) {
        T tmp = arr[leftIndex];
        arr[leftIndex] = arr[rightIndex];
        arr[rightIndex] = tmp;
    }

    /**
     * 颠倒数组
     *
     * @param arr
     */
    public static <T> void reverse(T[] arr) {
        reverse(arr, 0, arr.length);
    }

    /**
     * 颠倒[fromIndex,toIndex)范围内的数据
     *
     * @param arr
     * @param fromIndex
     * @param toIndex
     */
    public static <T> void reverse(T[] arr, int fromIndex, int toIndex) {
        toIndex--;
        while (fromIndex < toIndex) {
            swap(arr, fromIndex++, toIndex--);
        }
    }

    /**
     * 颠倒数组
     *
     * @param arr
     */
    public static void reverse(byte[] arr) {
        reverse(arr, 0, arr.length);
    }

    /**
     * 颠倒[fromIndex,toIndex)范围内的数据
     *
     * @param arr
     * @param fromIndex
     * @param toIndex
     */
    public static void reverse(byte[] arr, int fromIndex, int toIndex) {
        toIndex--;
        while (fromIndex < toIndex) {
            swap(arr, fromIndex++, toIndex--);
        }
    }

    /**
     * 颠倒数组
     *
     * @param arr
     */
    public static void reverse(short[] arr) {
        reverse(arr, 0, arr.length);
    }

    /**
     * 颠倒[fromIndex,toIndex)范围内的数据
     *
     * @param arr
     * @param fromIndex
     * @param toIndex
     */
    public static void reverse(short[] arr, int fromIndex, int toIndex) {
        toIndex--;
        while (fromIndex < toIndex) {
            swap(arr, fromIndex++, toIndex--);
        }
    }

    /**
     * 颠倒数组
     *
     * @param arr
     */
    public static void reverse(int[] arr) {
        reverse(arr, 0, arr.length);
    }

    /**
     * 颠倒[fromIndex,toIndex)范围内的数据
     *
     * @param arr
     * @param fromIndex
     * @param toIndex
     */
    public static void reverse(int[] arr, int fromIndex, int toIndex) {
        toIndex--;
        while (fromIndex < toIndex) {
            swap(arr, fromIndex++, toIndex--);
        }
    }


    /**
     * 颠倒数组
     *
     * @param arr
     */
    public static void reverse(long[] arr) {
        reverse(arr, 0, arr.length);
    }

    /**
     * 颠倒[fromIndex,toIndex)范围内的数据
     *
     * @param arr
     * @param fromIndex
     * @param toIndex
     */
    public static void reverse(long[] arr, int fromIndex, int toIndex) {
        toIndex--;
        while (fromIndex < toIndex) {
            swap(arr, fromIndex++, toIndex--);
        }
    }


    /**
     * 颠倒数组
     *
     * @param arr
     */
    public static void reverse(float[] arr) {
        reverse(arr, 0, arr.length);
    }

    /**
     * 颠倒[fromIndex,toIndex)范围内的数据
     *
     * @param arr
     * @param fromIndex
     * @param toIndex
     */
    public static void reverse(float[] arr, int fromIndex, int toIndex) {
        toIndex--;
        while (fromIndex < toIndex) {
            swap(arr, fromIndex++, toIndex--);
        }
    }


    /**
     * 颠倒数组
     *
     * @param arr
     */
    public static void reverse(double[] arr) {
        reverse(arr, 0, arr.length);
    }

    /**
     * 颠倒[fromIndex,toIndex)范围内的数据
     *
     * @param arr
     * @param fromIndex
     * @param toIndex
     */
    public static void reverse(double[] arr, int fromIndex, int toIndex) {
        toIndex--;
        while (fromIndex < toIndex) {
            swap(arr, fromIndex++, toIndex--);
        }
    }


    /**
     * 颠倒数组
     *
     * @param arr
     */
    public static void reverse(boolean[] arr) {
        reverse(arr, 0, arr.length);
    }

    /**
     * 颠倒[fromIndex,toIndex)范围内的数据
     *
     * @param arr
     * @param fromIndex
     * @param toIndex
     */
    public static void reverse(boolean[] arr, int fromIndex, int toIndex) {
        toIndex--;
        while (fromIndex < toIndex) {
            swap(arr, fromIndex++, toIndex--);
        }
    }

    /**
     * 颠倒数组
     *
     * @param arr
     */
    public static void reverse(char[] arr) {
        reverse(arr, 0, arr.length);
    }

    /**
     * 颠倒[fromIndex,toIndex)范围内的数据
     *
     * @param arr
     * @param fromIndex
     * @param toIndex
     */
    public static void reverse(char[] arr, int fromIndex, int toIndex) {
        toIndex--;
        while (fromIndex < toIndex) {
            swap(arr, fromIndex++, toIndex--);
        }
    }

    public static String toString(final Object[] array) {
        if (array == null || array.length == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (array.getClass().getComponentType() == String.class) {
            Object o = array[0];
            if (o == null) {
                sb.append("null");
            } else {
                sb.append("\"").append(o).append("\"");
            }
            sb.append("\"").append(array[0]);
            int length = array.length;
            for (int i = 1; i < length; i++) {
                o = array[i];
                if (o == null) {
                    sb.append(", null");
                } else {
                    sb.append(", \"").append(o).append("\"");
                }
            }
        } else {
            sb.append(array[0]);
            int length = array.length;
            for (int i = 1; i < length; i++) {
                sb.append(", ");
                sb.append(array[i]);
            }
        }
        sb.append("}");
        return sb.toString();
    }
}
