package com.github.azbh111.utils.java.collection;

import com.github.azbh111.utils.java.model.SortWrpper;
import com.github.azbh111.utils.java.iterable.IterableUtils;
import com.github.azbh111.utils.java.predicate.PredicateUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 *
 * @author pyz
 * @date 2019/4/2 10:32 AM
 */
public class CollectionUtils {

    public static <T> void distinctByKey(Collection<T> items, Function<T, Object> keyMapper) {
        if (items == null || items.isEmpty()) {
            return;
        }
        List<T> noConflict = items.stream().filter(PredicateUtils.distinctBy(keyMapper)).collect(Collectors.toList());
        items.clear();
        items.addAll(noConflict);
    }

    /**
     * 将items按给定的顺序排列
     * 无匹配的在最前面
     *
     * @param items
     * @param keys
     * @param keyMapper
     * @param <T>
     * @param <K>
     */
    public static <T, K> void sortMissingAtFirst(Collection<T> items, Collection<K> keys, Function<T, K> keyMapper) {
        sort(items, keys, keyMapper, Integer.MIN_VALUE);
    }

    /**
     * 将items按给定的顺序排列
     * 无匹配的在最后面
     *
     * @param items
     * @param keys
     * @param keyMapper
     * @param <T>
     * @param <K>
     */
    public static <T, K> void sortMissingAtLast(Collection<T> items, Collection<K> keys, Function<T, K> keyMapper) {
        sort(items, keys, keyMapper, Integer.MAX_VALUE);
    }

    private static <T, K> void sort(Collection<T> items, Collection<K> keys, Function<T, K> keyMapper, int missingSort) {
        if (items == null || items.isEmpty()) {
            return;
        }
        if (keys == null || keys.isEmpty()) {
            return;
        }
        Map<K, Integer> sortMap = new HashMap<>();
        int index = 0;
        for (K key : keys) {
            sortMap.put(key, index++);
        }
        List<SortWrpper<Integer, T>> toSort = IterableUtils.toList(items, item -> new SortWrpper(sortMap.getOrDefault(keyMapper.apply(item), missingSort), item));
        Collections.sort(toSort);
        items.clear();
        for (SortWrpper<Integer, T> wrapper : toSort) {
            items.add(wrapper.getData());
        }
    }


}
