package com.github.azbh111.utils.java.context;

import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author pyz
 * @date 2019/3/30 3:38 PM
 */
public class ThreadLocalContext {
    private static final ThreadLocal<Map<String, Object>> threadLocal = new ThreadLocal<>();

    static {
        threadLocal.set(new HashMap<>());
    }

    public static Map<String, Object> clear() {
        Map<String, Object> map = threadLocal.get();
        threadLocal.remove();
        return map;
    }

    public static <T> T get(String key) {
        return (T) get().get(key);
    }


    public static void set(String key, Object value) {
        get().put(key, value);
    }

    public static Object remove(String key) {
        return get().remove(key);
    }

    public static Map<String, Object> get() {
        Map<String, Object> map = threadLocal.get();
        if (map == null) {
            map = new HashMap<>();
            threadLocal.set(map);
        }
        return map;
    }
}
