package com.github.azbh111.utils.java.io.stream;

import java.io.IOException;
import java.io.OutputStream;

/**
 * @author: zyp
 * @date: 2020/1/19 4:35 PM
 */
public class CounterOutputStream extends OutputStream {
    private final OutputStream outputStream;
    private long count;

    public CounterOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void write(int b) throws IOException {
        outputStream.write(b);
        count++;
    }

    public long getCount() {
        return count;
    }
}
