package com.github.azbh111.utils.java.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

/**
 * @author pyz
 * @date 2019/4/13 6:28 PM
 */
public class MathUtils {
    /**
     * 判断两个数是否异号->一个大于0, 一个小于0
     *
     * @param
     * @return boolean
     * @author zhengyongpan
     * @since 2021/12/29 下午3:35
     */
    public static boolean isSignDiff(int num1, int num2) {
        return (num1 ^ num2) < 0;
    }

    /**
     * 判断是否是2的自然数次幂
     *
     * @param value value
     * @return boolean
     * @author zhengyongpan
     * @since 2021/12/29 下午3:21
     */
    public static boolean isPowerOfTwo(byte value) {
        return isPowerOfTwo((int) value);
    }

    /**
     * 判断是否是2的自然数次幂
     *
     * @param value value
     * @return boolean
     * @author zhengyongpan
     * @since 2021/12/29 下午3:21
     */
    public static boolean isPowerOfTwo(short value) {
        return isPowerOfTwo((int) value);
    }

    /**
     * 判断是否是2的自然数次幂
     *
     * @param value value
     * @return boolean
     * @author zhengyongpan
     * @since 2021/12/29 下午3:21
     */
    public static boolean isPowerOfTwo(int value) {
        return value > 0 && (value & (value - 1)) == 0;
    }

    /**
     * 判断是否是2的自然数次幂
     *
     * @param value value
     * @return boolean
     * @author zhengyongpan
     * @since 2021/12/29 下午3:21
     */
    public static boolean isPowerOfTwo(long value) {
        return value > 0 && (value & (value - 1)) == 0;
    }

    /**
     * 四舍五入保留指定位数的小数
     *
     * @param value
     * @param scale
     * @return
     */
    public static double toFixed(double value, int scale) {
        return toFixed(value, scale, RoundingMode.HALF_UP);
    }

    /**
     * 保留指定位数的小数
     *
     * @param value
     * @param scale
     * @param roundingMode 舍入算法
     * @return
     */
    public static double toFixed(double value, int scale, RoundingMode roundingMode) {
        return BigDecimal.valueOf(value).setScale(scale, roundingMode).doubleValue();
    }

    /**
     * 四舍五入保留指定位数的小数
     *
     * @param value
     * @param scale
     * @return
     */
    public static double toFixed(long value, int scale) {
        return toFixed(value, scale, RoundingMode.HALF_UP);
    }

    /**
     * 保留指定位数的小数
     *
     * @param value
     * @param scale
     * @param roundingMode 舍入算法
     * @return
     */
    public static double toFixed(long value, int scale, RoundingMode roundingMode) {
        return BigDecimal.valueOf(value).setScale(scale, roundingMode).doubleValue();
    }

    /**
     * 四舍五入保留指定位数的小数
     *
     * @param value
     * @param scale
     * @return
     */
    public static String toFixedString(double value, int scale) {
        return toFixedString(value, scale, RoundingMode.HALF_UP);
    }

    /**
     * 保留指定位数的小数
     *
     * @param value
     * @param scale
     * @param roundingMode 舍入算法
     * @return
     */
    public static String toFixedString(double value, int scale, RoundingMode roundingMode) {
        return BigDecimal.valueOf(value).setScale(scale, roundingMode).stripTrailingZeros().toPlainString();
    }

    /**
     * 四舍五入保留指定位数的小数
     *
     * @param value
     * @param scale
     * @return
     */
    public static String toFixedString(long value, int scale) {
        return toFixedString(value, scale, RoundingMode.HALF_UP);
    }

    /**
     * 保留指定位数的小数
     *
     * @param value
     * @param scale
     * @param roundingMode 舍入算法
     * @return
     */
    public static String toFixedString(long value, int scale, RoundingMode roundingMode) {
        return BigDecimal.valueOf(value).setScale(scale, roundingMode).stripTrailingZeros().toPlainString();
    }

    /**
     * 判断奇数
     *
     * @param value
     * @return
     */
    public static boolean isOdd(int value) {
        return (value & 1) == 1;
    }

    /**
     * 计算 radix的power次幂(power>=0)
     *
     * @param radix
     * @param power
     * @return
     */
    public static long powIntegral(long radix, long power) {
        if (radix == 0) {
            return 0;
        }
        if (power < 0) {
            throw new IllegalArgumentException(radix + "," + power);
        }
        if (power == 0) {
            return 1;
        }
        long r = radix;
        while (power > 1) {
            r *= radix;
            power--;
        }
        return r;
    }

    /**
     * 计算 radix的power次幂(power>=0)
     *
     * @param radix
     * @param power
     * @return 可能会溢出
     */
    public static int powIntegral(int radix, int power) {
        if (radix == 0) {
            return 0;
        }
        if (power < 0) {
            throw new IllegalArgumentException(radix + "," + power);
        }
        if (power == 0) {
            return 1;
        }
        int r = radix;
        while (power > 1) {
            r *= radix;
            power--;
        }
        return r;
    }

    /**
     * 计算 radix的power次幂(power>=0)
     *
     * @param radix
     * @param power
     * @return 可能会溢出
     */
    public static long powIntegralL(int radix, int power) {
        if (radix == 0) {
            return 0;
        }
        if (power < 0) {
            throw new IllegalArgumentException(radix + "," + power);
        }
        if (power == 0) {
            return 1;
        }
        long r = radix;
        while (power > 1) {
            r *= radix;
            power--;
        }
        return r;
    }

    /**
     * 从2开始寻找指定数量的质数
     *
     * @param count
     * @return
     */
    public static List<Integer> findPrimes(int count) {
        List<Integer> rs = new ArrayList<>(count);
        int num = 2;
        while (rs.size() < count) {
            if (isPrime(num)) {
                rs.add(num);
            }
            num++;
        }
        return rs;
    }

    /**
     * 判断是否是质数
     *
     * @param number
     * @return
     */
    public static boolean isPrime(int number) {
        if (number <= 1) {
            // 质数定义在大于1的整数中
            return false;
        }
        if (number <= 3) {
            // 2/3是质数
            return true;
        }
        if ((number & 1) == 0) {
            // 偶数
            return false;
        }
        if (number % 3 == 0) {
            // 被3整除
            return false;
        }
        int top = (int) Math.sqrt(number);
        if (top * top == number) {
            // 平方数
            return false;
        }
        int i = 3, j = 5;
        while (i <= top && j <= top) {
            if (number % i == 0 || number % j == 0) {
                return false;
            }
            i += 2;
            j += 2;
        }
        return true;
    }
}
