package com.github.azbh111.utils.java.math;

import com.github.azbh111.utils.java.math.permutation.*;

import java.util.Comparator;

/**
 * 处理排列相关
 *
 * @author pyz
 * @date 2019/4/14 9:49 AM
 */
public class PermutationUtils {

    /**
     * 基于SJT算法的[0,count)序列的全排列生成器
     *
     * 每次迭代只是交换数组中元素的位置,若需要,请自行拷贝
     *
     *
     * @param count count >= 0
     * @return
     */
    public static FullPermutationGenerator fullPermutation(int count) {
        return new FullPermutationGenerator(count);
    }

    /**
     * 字典序全排列
     *
     * @param arr
     * @return
     */
    public static PermutationHolder dictionaryPermutation(byte[] arr) {
        return new BytePermutationHolder(arr);
    }

    /**
     * 字典序全排列
     *
     * @param arr
     * @return
     */
    public static PermutationHolder dictionaryPermutation(short[] arr) {
        return new ShortPermutationHolder(arr);
    }

    /**
     * 字典序全排列
     *
     * @param arr
     * @return
     */
    public static PermutationHolder dictionaryPermutation(int[] arr) {
        return new IntPermutationHolder(arr);
    }

    /**
     * 字典序全排列
     *
     * @param arr
     * @return
     */
    public static PermutationHolder dictionaryPermutation(long[] arr) {
        return new LongPermutationHolder(arr);
    }

    /**
     * 字典序全排列
     *
     * @param arr
     * @return
     */
    public static PermutationHolder dictionaryPermutation(float[] arr) {
        return new FloatPermutationHolder(arr);
    }

    /**
     * 字典序全排列
     *
     * @param arr
     * @return
     */
    public static PermutationHolder dictionaryPermutation(double[] arr) {
        return new DoublePermutationHolder(arr);
    }

    /**
     * 字典序全排列
     *
     * @param arr
     * @return
     */
    public static PermutationHolder dictionaryPermutation(char[] arr) {
        return new CharPermutationHolder(arr);
    }


    /**
     * 字典序全排列
     *
     * @param arr
     * @return
     */
    public static <T extends Comparable> PermutationHolder dictionaryPermutation(T[] arr) {
        return new ObjectPermutationHolder<>(arr);
    }

    /**
     * 字典序全排列
     *
     * @param arr
     * @return
     */
    public static <T> PermutationHolder dictionaryPermutation(T[] arr, Comparator<T> comparator) {
        return new ObjectPermutationHolder<>(arr, comparator);
    }

}
