package com.github.azbh111.utils.java.math.permutation;

import com.github.azbh111.utils.java.array.ArrayUtils;

import java.util.Comparator;

/**
 *
 * @author pyz
 * @date 2019/4/14 11:13 AM
 */
public class ObjectPermutationHolder<T> extends PermutationHolder {
    private final Object[] arr;
    private final Comparator<Object> comparator;

    public <T extends Comparable> ObjectPermutationHolder(T[] arr) {
        this.arr = arr;
        this.comparator = (Comparator) new Comparator<T>() {
            @Override
            public int compare(T o1, T o2) {
                return o1.compareTo(o2);
            }
        };
    }

    public <T> ObjectPermutationHolder(T[] arr, Comparator<T> comparator) {
        this.arr = arr;
        this.comparator = (Comparator<Object>) comparator;
    }

    @Override
    public int length() {
        return arr.length;
    }

    @Override
    public int compare(int i, int j) {
        return comparator.compare(arr[i], arr[j]);
    }

    @Override
    public void swap(int i, int j) {
        Object n = arr[i];
        arr[i] = arr[j];
        arr[j] = n;
    }

    @Override
    public void reverse(int fromIndex, int toIndex) {
        ArrayUtils.reverse(arr, fromIndex, toIndex);
    }
}
