package com.github.azbh111.utils.java.model;

import lombok.Getter;
import lombok.NonNull;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * @author pyz
 * @date 2019/6/19 8:46 PM
 */
@Getter
@Setter
@ToString
public class SortWrpper<C extends Comparable, T> implements Comparable<SortWrpper>, Serializable {
    private static final long serialVersionUID = 1067562144473066103L;

    private C sort;
    private T data;

    public SortWrpper(@NonNull C sort, T data) {
        this.sort = sort;
        this.data = data;
    }

    @Override
    public int compareTo(SortWrpper o) {
        return sort.compareTo(o.sort);
    }
}
