package com.github.azbh111.utils.java.sys;

import com.github.azbh111.utils.java.thread.ThreadUtils;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.function.Consumer;

/**
 *
 * @author pyz
 * @date 2019/11/26 11:05 上午
 */
public class RuntimeUtils {

    /**
     * 停止当前进程
     * 若指定时间内未停止,就调用命令行强制杀掉
     * @param timeout 超时时间 ms
     * @param logger 日志记录器 可空
     * @param exceptionHandler 异常处理器 可空
     * @throws IOException
     */
    public static void forceExit(long timeout, Consumer<String> logger, Consumer<Throwable> exceptionHandler) {
        if (logger == null) {
            logger = i -> {
            };
        }
        if (exceptionHandler == null) {
            exceptionHandler = Throwable::printStackTrace;
        }
        Consumer<Throwable> fExceptionHandler = exceptionHandler;
        Consumer<String> fLogger = logger;
        Thread t = new Thread(() -> {
            try {
                ThreadUtils.sleepSafe(timeout);
            } catch (Throwable e) {
                fExceptionHandler.accept(e);
            }
            try {
                forceExit(fLogger);
            } catch (Throwable e) {
                fExceptionHandler.accept(e);
            }
        });
        t.setDaemon(true);
        t.setName("force exit watch dog");
        t.start();
        try {
            logger.accept("try System.exit(0)");
            System.exit(0);
        } catch (Exception e) {
            logger.accept("fail System.exit(0)");
            exceptionHandler.accept(e);
            forceExit(logger);
        }
    }

    private static void forceExit(Consumer<String> logger) {
        final RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        final String name = runtime.getName();
        logger.accept("process name: " + name);
        String pid = name.split("@")[0];
        logger.accept("process pid: " + pid);
        logger.accept("os name: " + OSUtils.getOSName());
        String command;
        if (OSUtils.isWindows()) {
            command = "taskkill /pid " + pid + " /f";
        } else if (OSUtils.isMac() || OSUtils.isLinux()) {
            command = "kill -9 " + pid;
        } else {
            throw new RuntimeException("unkown os: " + OSUtils.getOSName());
        }
        logger.accept("command: " + command);
//        休眠一下,让日志输出完毕
        ThreadUtils.sleepSafe(10);
        try {
            Process p = Runtime.getRuntime().exec(command);
        } catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

}
