/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.csv;

import com.github.azbh111.utils.java.csv.CsvColumnDefine;
import com.github.azbh111.utils.java.csv.CsvExporter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;

public class CsvExporterTask<T> {
    private final Class<T> cls;
    private final List<CsvColumnDefine> columns;
    private final BufferedWriter writer;
    private final CsvExporter exporter;

    public CsvExporterTask(CsvExporter exporter, Class<T> cls, OutputStream outputStream) {
        this(exporter, cls, new BufferedWriter(new OutputStreamWriter(outputStream, exporter.getCharset())));
    }

    public CsvExporterTask(CsvExporter exporter, Class<T> cls, Writer writer) {
        this.exporter = exporter;
        this.cls = cls;
        this.writer = new BufferedWriter(writer);
        this.columns = exporter.getColumns(cls);
    }

    public CsvExporterTask put(List<T> batchList) {
        return this.put(batchList.iterator());
    }

    public CsvExporterTask put(Iterator<T> batchList) {
        try {
            while (batchList.hasNext()) {
                T item = batchList.next();
                boolean writeComma = false;
                for (CsvColumnDefine column : this.columns) {
                    if (writeComma) {
                        this.writer.write(",");
                    }
                    writeComma = true;
                    Object value = column.get(item);
                    String str = value == null ? column.getNullValue() : column.getConventor().apply(value);
                    this.writeCell(str, this.writer);
                }
                this.writer.newLine();
            }
        }
        catch (Throwable x) {
            throw new RuntimeException(x);
        }
        return this;
    }

    public CsvExporterTask start() {
        try {
            boolean writeComma = false;
            for (CsvColumnDefine column : this.columns) {
                if (writeComma) {
                    this.writer.write(",");
                }
                writeComma = true;
                this.writeCell(column.getName(), this.writer);
            }
            this.writer.newLine();
        }
        catch (Throwable x) {
            throw new RuntimeException(x);
        }
        return this;
    }

    private void writeCell(String value, BufferedWriter output) throws IOException {
        output.write("\"");
        output.write(value.replaceAll("\"", "\"\""));
        output.write("\"");
    }

    public CsvExporterTask finish() {
        try {
            this.writer.close();
        }
        catch (Throwable x) {
            throw new RuntimeException(x);
        }
        return this;
    }

    public Class<T> getCls() {
        return this.cls;
    }

    public List<CsvColumnDefine> getColumns() {
        return this.columns;
    }

    public BufferedWriter getWriter() {
        return this.writer;
    }

    public CsvExporter getExporter() {
        return this.exporter;
    }

    public String toString() {
        return "CsvExporterTask(super=" + super.toString() + ", cls=" + this.getCls() + ", columns=" + this.getColumns() + ", writer=" + this.getWriter() + ", exporter=" + this.getExporter() + ")";
    }
}

