/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.date;

import com.github.azbh111.utils.java.date.DateParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class DateParser {
    private Locale locale = Locale.getDefault();
    private TimeZone timeZone = TimeZone.getDefault();
    private ZoneId zoneId = this.timeZone.toZoneId();

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.zoneId = timeZone.toZoneId();
    }

    public void setTimeZone(ZoneId zoneId) {
        this.zoneId = zoneId;
        this.timeZone = TimeZone.getTimeZone(zoneId);
    }

    public long parseTimestamp(String str) {
        if (str == null || str.isEmpty()) {
            throw new DateParseException(String.format("can not convert '%s' to timestamp", str));
        }
        Scanner scanner = new Scanner(str);
        return scanner.toTimestamp();
    }

    public Date parseDate(String str) {
        long timestamp = this.parseTimestamp(str);
        return new Date(timestamp);
    }

    public Date parseSqlDate(String str) {
        long timestamp = this.parseTimestamp(str);
        return new java.sql.Date(timestamp);
    }

    public Instant parseInstant(String str) {
        long timestamp = this.parseTimestamp(str);
        return Instant.ofEpochMilli(timestamp);
    }

    public LocalDateTime parseLocalDateTime(String str) {
        Instant instant = this.parseInstant(str);
        return LocalDateTime.ofInstant(instant, this.zoneId);
    }

    public LocalDate parseLocalDate(String str) {
        return this.parseLocalDateTime(str).toLocalDate();
    }

    public LocalTime parseTime(String str) {
        return this.parseLocalDateTime(str).toLocalTime();
    }

    public ZonedDateTime parseZonedDateTime(String str) {
        if (str == null || str.isEmpty()) {
            throw new DateParseException(String.format("can not convert '%s' to timestamp", str));
        }
        Scanner scanner = new Scanner(str);
        long timestamp = scanner.toTimestamp();
        Instant instant = Instant.ofEpochMilli(timestamp);
        return ZonedDateTime.ofInstant(instant, scanner.getTimeZone().toZoneId());
    }

    public OffsetDateTime parseOffsetDateTime(String str) {
        if (str == null || str.isEmpty()) {
            throw new DateParseException(String.format("can not convert '%s' to timestamp", str));
        }
        Scanner scanner = new Scanner(str);
        long timestamp = scanner.toTimestamp();
        Instant instant = Instant.ofEpochMilli(timestamp);
        return OffsetDateTime.ofInstant(instant, scanner.getTimeZone().toZoneId());
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public String toString() {
        return "DateParser(super=" + super.toString() + ", locale=" + this.getLocale() + ", timeZone=" + this.getTimeZone() + ", zoneId=" + this.getZoneId() + ")";
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private class Scanner {
        private static final char EOI = '\u001a';
        private final String text;
        private final char[] data;
        private final int dataLen;
        private Calendar calendar = null;
        private int readPos;
        int year;
        int month;
        int day;
        int hour;
        int minute;
        int second;
        int millis;
        Integer zoneRawOffset;
        String zoneIdName;
        TimeZone timeZone;
        String zoneId;

        public Scanner(String text) {
            this.text = text.trim();
            this.data = this.text.toCharArray();
            this.dataLen = this.data.length;
            this.readPos = 0;
        }

        public long toTimestamp() {
            if (this.isNumber()) {
                return Long.parseLong(this.text);
            }
            this.year = this.readNumber(4, -1, -1);
            if (this.year == -1) {
                return -1L;
            }
            this.skip(1);
            this.month = this.readNumber(2, 1, 12);
            if (this.month == -1) {
                return -1L;
            }
            this.skip(1);
            this.day = this.readNumber(2, 1, 31);
            if (this.month == -1) {
                return -1L;
            }
            char ch = this.peek();
            if (ch == '\u001a') {
                return this.getTimestamp();
            }
            int digitPos = this.nextDigitPos();
            if (digitPos == -1) {
                return -1L;
            }
            this.pos(digitPos);
            this.hour = this.readNumber(2, 0, 23);
            if (this.hour == -1) {
                return -1L;
            }
            if (this.peek() == '\u001a') {
                return this.getTimestamp();
            }
            this.skip(1);
            this.minute = this.readNumber(2, 0, 59);
            if (this.minute == -1) {
                return -1L;
            }
            if (this.peek() == '\u001a') {
                return this.getTimestamp();
            }
            this.skip(1);
            this.second = this.readNumber(2, 0, 60);
            if (this.second == -1) {
                return -1L;
            }
            ch = this.peek();
            if (ch == '\u001a') {
                return this.getTimestamp();
            }
            if (ch == '.') {
                this.read();
                this.millis = this.readNumber(3, 0, 999);
                if (this.millis == -1) {
                    return -1L;
                }
            }
            if ((ch = this.peek()) == '\u001a') {
                return this.getTimestamp();
            }
            this.zoneRawOffset = this.readZoneOffset();
            if (this.zoneRawOffset == null) {
                return -1L;
            }
            ch = this.peek();
            if (ch == '\u001a') {
                return this.getTimestamp();
            }
            if (ch != '[') {
                return -1L;
            }
            this.read();
            ch = this.charAt(this.dataLen - 1);
            if (ch != ']') {
                return -1L;
            }
            this.zoneId = this.substring(this.readPos, this.dataLen - 1);
            return this.getTimestamp();
        }

        private char charAt(int index) {
            if (index < this.dataLen) {
                return this.data[index];
            }
            return '\u001a';
        }

        private String substring(int beginIndex, int endIndex) {
            return new String(this.data, beginIndex, endIndex - beginIndex);
        }

        private Integer readZoneOffset() {
            char ch = this.peek();
            int signal = 1;
            if (ch == 'Z') {
                this.read();
                this.zoneIdName = "Z";
                return 0;
            }
            if (ch != '+') {
                if (ch == '-') {
                    signal = -1;
                } else {
                    return null;
                }
            }
            int zoneOffsetStartIndex = this.readPos;
            this.read();
            int hourOffset = this.readNumber(2, 0, 16);
            if (hourOffset == -1) {
                return null;
            }
            int offsetMilliseconds = hourOffset * 3600 * 1000;
            ch = this.peek();
            if (ch == '\u001a') {
                return offsetMilliseconds * signal;
            }
            if (ch != ':') {
                return offsetMilliseconds * signal;
            }
            this.read();
            int minuteOffset = this.readNumber(2, 0, 59);
            if (minuteOffset == -1) {
                return null;
            }
            int zoneOffsetEndIndex = this.readPos;
            this.zoneIdName = this.substring(zoneOffsetStartIndex, zoneOffsetEndIndex);
            return (offsetMilliseconds += minuteOffset * 60 * 1000) * signal;
        }

        private long getTimestamp() {
            if (this.zoneId != null) {
                this.timeZone = TimeZone.getTimeZone(this.zoneId);
                this.calendar = Calendar.getInstance(TimeZone.getTimeZone(this.zoneId), DateParser.this.locale);
            } else if (this.zoneRawOffset != null) {
                this.timeZone = new SimpleTimeZone(this.zoneRawOffset, this.zoneIdName);
                this.calendar = Calendar.getInstance(this.timeZone, DateParser.this.locale);
            } else {
                this.timeZone = DateParser.this.timeZone;
            }
            this.calendar = Calendar.getInstance(this.timeZone, DateParser.this.locale);
            this.calendar.setTimeInMillis(0L);
            this.calendar.set(this.year, this.month - 1, this.day, this.hour, this.minute, this.second);
            return this.calendar.getTimeInMillis() + (long)this.millis;
        }

        private int nextDigitPos() {
            for (int i = this.readPos; i < this.dataLen; ++i) {
                if (!Character.isDigit(this.data[i])) continue;
                return i;
            }
            return -1;
        }

        private int readNumber(int maxNumberLen, int min, int max) {
            if (this.readPos + maxNumberLen > this.dataLen) {
                return -1;
            }
            int number = 0;
            while (maxNumberLen-- > 0) {
                char y = this.peek();
                if (y < '0' || y > '9') {
                    return -1;
                }
                number = number * 10 + y - 48;
                this.read();
            }
            if (min != -1 && number < min) {
                return -1;
            }
            if (max != -1 && number > max) {
                return -1;
            }
            return number;
        }

        private char peek() {
            if (this.readPos < this.dataLen) {
                return this.data[this.readPos];
            }
            return '\u001a';
        }

        private char read() {
            if (this.readPos < this.dataLen) {
                return this.data[this.readPos++];
            }
            return '\u001a';
        }

        private void skip(int len) {
            this.readPos += len;
        }

        private void pos(int readPos) {
            this.readPos = readPos;
        }

        private boolean isNumber() {
            if (this.data[0] == '-') {
                return true;
            }
            for (int i = 0; i < this.dataLen; ++i) {
                char c = this.data[i];
                if (c >= '0' && c <= '9') continue;
                return false;
            }
            return true;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }
    }
}

