/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.lang;

import java.util.Arrays;

public class Speedometer {
    private long[] data;
    private int capacity;
    private int second;
    private final long startTime = System.currentTimeMillis();

    public Speedometer() {
        this(4096);
    }

    public Speedometer(int size) {
        this.capacity = size <= 0 ? 1 : Speedometer.ceilPowerOf2(size);
        this.data = new long[this.capacity];
    }

    public void add(long count) {
        int head = this.head();
        this.set(head, this.get(head) + count);
    }

    public double speed(int second) {
        if (second <= 0) {
            throw new IllegalArgumentException();
        }
        int head = this.head();
        if (second > head) {
            second = head;
        }
        if (second >= this.capacity) {
            second = this.capacity - 1;
        }
        long from = this.get(head - second);
        long to = this.get(head - 1);
        return ((double)to - (double)from) / (double)second;
    }

    public double speed() {
        int time = (int)((System.currentTimeMillis() - this.startTime) / 1000L);
        return (double)this.get(this.second) / (double)time;
    }

    private int head() {
        int from;
        int to = (int)((System.currentTimeMillis() - this.startTime) / 1000L);
        if (to - (from = this.second) > this.capacity) {
            Arrays.fill(this.data, this.get(from));
        } else {
            long v = this.get(from);
            while (++from <= to) {
                this.set(from, v);
            }
        }
        this.second = to;
        return to;
    }

    private long get(int index) {
        return this.data[index & this.capacity - 1];
    }

    private void set(int index, long v) {
        this.data[index & this.capacity - 1] = v;
    }

    private static int indexOfHighestBit(int v) {
        if (v == 0) {
            return -1;
        }
        if (v < 0) {
            return 31;
        }
        int from = 0;
        int to = 31;
        while (from < to) {
            int mid = from + (to + 1 - from >> 1);
            if (v >>> mid > 0) {
                from = mid;
                continue;
            }
            to = mid - 1;
        }
        return from;
    }

    private static boolean isPowerOf2(int n) {
        if (n <= 0) {
            return false;
        }
        return (n & n - 1) == 0;
    }

    private static int ceilPowerOf2(int target) {
        if (target <= 0) {
            throw new IllegalArgumentException(String.format("\u975e\u6cd5\u8f93\u5165: %s", target));
        }
        if (Speedometer.isPowerOf2(target)) {
            return target;
        }
        int highestBit = Speedometer.indexOfHighestBit(target);
        if (highestBit == 31) {
            return Integer.MAX_VALUE;
        }
        return 1 << highestBit << 1;
    }
}

