/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.math;

import com.github.azbh111.utils.java.math.MathUtils;
import java.util.ArrayList;

public class RadixUtils {
    public static int[] toRadixRatios(long value, int radix) {
        if (radix < 2) {
            throw new IllegalArgumentException(radix + "");
        }
        ArrayList<Integer> ratios = new ArrayList<Integer>();
        while (value != 0L) {
            int mod = (int)(value % (long)radix);
            ratios.add(mod);
            value /= (long)radix;
        }
        int[] ratioArr = new int[ratios.size()];
        int size = ratios.size();
        for (int i = 0; i < size; ++i) {
            ratioArr[i] = (Integer)ratios.get(i);
        }
        return ratioArr;
    }

    public static long valueOf(int radix, int[] ratios) {
        long r = 0L;
        for (int i = 0; i < ratios.length; ++i) {
            r += (long)ratios[i] * MathUtils.powIntegralL(radix, i);
        }
        return r;
    }

    public static int numberAt(long value, int radix, int index) {
        long subNumber = MathUtils.powIntegralL(radix, index);
        return (int)((value /= subNumber) % (long)radix);
    }

    public static String toString(long value, int radix) {
        return Long.toString(value, radix);
    }

    public static String toString(int value, int radix) {
        return Integer.toString(value, radix);
    }
}

