/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.math.permutation;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class FullPermutationGenerator
implements Iterable<int[]> {
    private final int count;

    public FullPermutationGenerator(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(n + "");
        }
        this.count = n;
    }

    public static Stream<int[]> stream(int n) {
        return (Stream)new FullPermutationGenerator(n).stream().parallel();
    }

    public Stream<int[]> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public Iterator<int[]> iterator() {
        return new FullPermutationGeneratorIterator();
    }

    public class FullPermutationGeneratorIterator
    implements Iterator<int[]> {
        private final int[] indexArr;
        private final int[] moveArr;
        private boolean cached = false;
        private int[] next;

        private FullPermutationGeneratorIterator() {
            this.indexArr = new int[FullPermutationGenerator.this.count];
            this.moveArr = new int[FullPermutationGenerator.this.count];
            for (int i = 0; i < FullPermutationGenerator.this.count; ++i) {
                this.indexArr[i] = i;
                this.moveArr[i] = -1;
            }
            this.cached = true;
            this.next = this.indexArr;
        }

        private void swap(int[] intarr, int i, int j) {
            int temp = intarr[i];
            intarr[i] = intarr[j];
            intarr[j] = temp;
        }

        @Override
        public boolean hasNext() {
            int i;
            if (this.cached) {
                return this.next != null;
            }
            int j = FullPermutationGenerator.this.count;
            for (i = FullPermutationGenerator.this.count - 1; i >= 0; --i) {
                if (i + this.moveArr[i] >= FullPermutationGenerator.this.count || i + this.moveArr[i] < 0 || this.indexArr[i] <= this.indexArr[i + this.moveArr[i]]) continue;
                if (j == FullPermutationGenerator.this.count) {
                    j = i;
                    continue;
                }
                if (this.indexArr[i] <= this.indexArr[j]) continue;
                j = i;
            }
            if (j == FullPermutationGenerator.this.count) {
                this.cached = true;
                this.next = null;
                return false;
            }
            int t = this.indexArr[j];
            i = j + this.moveArr[j];
            this.swap(this.indexArr, i, j);
            this.swap(this.moveArr, i, j);
            for (i = 0; i < FullPermutationGenerator.this.count; ++i) {
                if (this.indexArr[i] <= t) continue;
                this.moveArr[i] = -this.moveArr[i];
            }
            this.cached = true;
            this.next = this.indexArr;
            return this.next != null;
        }

        @Override
        public int[] next() {
            if (!this.cached) {
                this.hasNext();
            }
            this.cached = false;
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            return this.next;
        }
    }
}

