/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.net;

import com.github.azbh111.utils.java.net.NetUtils;

public class IpMaskFilter {
    private static final int ipLen = 4;
    private final byte[] mask;
    private final byte[] target;

    public IpMaskFilter(byte[] mask, byte[] target) {
        this.validate(mask);
        this.validate(target);
        this.mask = mask;
        this.target = target;
    }

    public boolean match(byte[] ip) {
        if (ip == null || ip.length != 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if ((ip[i] & this.mask[i]) == this.target[i]) continue;
            return false;
        }
        return true;
    }

    public boolean match(String ip) {
        if (ip == null || ip.length() == 0) {
            return false;
        }
        int fromIndex = 0;
        for (int i = 0; i < 4; ++i) {
            int dotPos = ip.indexOf(46, fromIndex);
            byte val = dotPos == -1 ? NetUtils.toIpByte(Integer.parseInt(ip.substring(fromIndex))) : NetUtils.toIpByte(Integer.parseInt(ip.substring(fromIndex, dotPos)));
            if ((val & this.mask[i]) != this.target[i]) {
                return false;
            }
            fromIndex = dotPos + 1;
        }
        return true;
    }

    private void validate(byte[] ip) {
        if (ip == null) {
            throw new NullPointerException();
        }
        if (ip.length != 4) {
            throw new RuntimeException("length of ip not equals 4");
        }
    }

    public String toString() {
        return NetUtils.toIpString(this.mask) + " " + NetUtils.toIpString(this.target);
    }
}

