/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.net;

import com.github.azbh111.utils.java.net.IpMaskFilter;
import com.github.azbh111.utils.java.net.Ips;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;

public class NetUtils {
    private static final List<IpMaskFilter> INNER_IP_MASK_FILTERS = new ArrayList<IpMaskFilter>();

    public static Ips getIp() throws SocketException {
        LinkedHashMap<String, List<String>> localIps = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, List<String>> netIps = new LinkedHashMap<String, List<String>>();
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        InetAddress inetAddress = null;
        boolean finded = false;
        while (netInterfaces.hasMoreElements() && !finded) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                inetAddress = address.nextElement();
                if (inetAddress.getAddress().length != 4) continue;
                if (NetUtils.isInnerIp(inetAddress.getAddress())) {
                    localIps.computeIfAbsent(ni.getName(), k -> new ArrayList()).add(inetAddress.getHostAddress());
                    continue;
                }
                netIps.computeIfAbsent(ni.getName(), k -> new ArrayList()).add(inetAddress.getHostAddress());
            }
        }
        return new Ips(localIps, netIps);
    }

    public static boolean isInnerIp(String ip) {
        if (ip == null) {
            return false;
        }
        for (IpMaskFilter ipMaskFilter : INNER_IP_MASK_FILTERS) {
            if (!ipMaskFilter.match(ip)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInnerIp(byte[] ip) {
        if (ip == null) {
            return false;
        }
        for (IpMaskFilter ipMaskFilter : INNER_IP_MASK_FILTERS) {
            if (!ipMaskFilter.match(ip)) continue;
            return true;
        }
        return false;
    }

    public static String toIpString(byte[] ip) {
        NetUtils.validate(ip);
        StringBuilder sb = new StringBuilder(15);
        sb.append(NetUtils.toIpInt(ip[0]));
        sb.append('.');
        sb.append(NetUtils.toIpInt(ip[1]));
        sb.append('.');
        sb.append(NetUtils.toIpInt(ip[2]));
        sb.append('.');
        sb.append(NetUtils.toIpInt(ip[3]));
        return sb.toString();
    }

    public static int toIpInt(byte value) {
        return value < 0 ? value + 256 : value;
    }

    public static int[] toIpInt(byte[] ip) {
        int[] val = new int[4];
        for (int i = 0; i < 4; ++i) {
            val[i] = NetUtils.toIpInt(ip[i]);
        }
        return val;
    }

    public static byte toIpByte(int value) {
        return (byte)(value > 127 ? value - 256 : value);
    }

    public static byte[] toIpByte(int[] ip) {
        byte[] val = new byte[4];
        for (int i = 0; i < 4; ++i) {
            val[i] = NetUtils.toIpByte(ip[i]);
        }
        return val;
    }

    public static void validate(byte[] ip) {
        if (ip == null) {
            throw new NullPointerException();
        }
        if (ip.length != 4) {
            throw new RuntimeException("length of ip not equals 4");
        }
    }

    static {
        INNER_IP_MASK_FILTERS.add(new IpMaskFilter(NetUtils.toIpByte(new int[]{255, 0, 0, 0}), NetUtils.toIpByte(new int[]{10, 0, 0, 0})));
        INNER_IP_MASK_FILTERS.add(new IpMaskFilter(NetUtils.toIpByte(new int[]{255, 255, 0, 0}), NetUtils.toIpByte(new int[]{172, 16, 0, 0})));
        INNER_IP_MASK_FILTERS.add(new IpMaskFilter(NetUtils.toIpByte(new int[]{255, 255, 255, 255}), NetUtils.toIpByte(new int[]{192, 166, 0, 0})));
        INNER_IP_MASK_FILTERS.add(new IpMaskFilter(NetUtils.toIpByte(new int[]{255, 255, 255, 255}), NetUtils.toIpByte(new int[]{127, 0, 0, 1})));
        INNER_IP_MASK_FILTERS.add(new IpMaskFilter(NetUtils.toIpByte(new int[]{255, 255, 255, 255}), NetUtils.toIpByte(new int[]{0, 0, 0, 0})));
    }
}

