/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bbottema.javareflection.model.LookupMode;
import org.bbottema.javareflection.valueconverter.ValueConversionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeUtils {
    private static final Map<Class<?>, Integer> numSizes = new LinkedHashMap();

    @NotNull
    public static Class<?>[] collectTypes(Object[] objects) {
        if (objects == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.collectTypes must not be null");
        }
        Class[] types = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object o = objects[i];
            types[i] = o != null ? o.getClass() : Object.class;
        }
        if (types == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/TypeUtils.collectTypes must not return null");
        }
        return types;
    }

    public static boolean isTypeListCompatible(Class<?>[] inputTypeList, Class<?>[] targetTypeList, EnumSet<LookupMode> lookupMode) {
        if (inputTypeList == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.isTypeListCompatible must not be null");
        }
        if (targetTypeList == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/TypeUtils.isTypeListCompatible must not be null");
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/TypeUtils.isTypeListCompatible must not be null");
        }
        List<Class<?>[]> derivableTypeLists = TypeUtils.generateCompatibleTypeLists(lookupMode, inputTypeList);
        for (Class<?>[] derivableTypeList : derivableTypeLists) {
            boolean currentTypeListCompatible = true;
            for (int i = 0; i < derivableTypeList.length && currentTypeListCompatible; ++i) {
                if (derivableTypeList[i].equals(targetTypeList[i])) continue;
                currentTypeListCompatible = false;
            }
            if (!currentTypeListCompatible) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<Class<?>[]> generateCompatibleTypeLists(EnumSet<LookupMode> lookupMode, Class<?> ... typeList) {
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.generateCompatibleTypeLists must not be null");
        }
        if (typeList == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/TypeUtils.generateCompatibleTypeLists must not be null");
        }
        ArrayList<Class<?>[]> typeLists = new ArrayList<Class<?>[]>();
        TypeUtils.generateCompatibleTypeLists(0, lookupMode, typeLists, typeList);
        ArrayList<Class<?>[]> arrayList = typeLists;
        if (arrayList == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/TypeUtils.generateCompatibleTypeLists must not return null");
        }
        return arrayList;
    }

    private static void generateCompatibleTypeLists(int index, EnumSet<LookupMode> lookupMode, List<Class<?>[]> typeLists, Class<?> ... currentTypelist) {
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/TypeUtils.generateCompatibleTypeLists must not be null");
        }
        if (typeLists == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/TypeUtils.generateCompatibleTypeLists must not be null");
        }
        if (currentTypelist == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/TypeUtils.generateCompatibleTypeLists must not be null");
        }
        if (index == currentTypelist.length) {
            typeLists.add(currentTypelist);
        } else {
            Class[] newTypeList;
            Class<?>[] autoboxed;
            Class<?> original = currentTypelist[index];
            TypeUtils.generateCompatibleTypeLists(index + 1, lookupMode, typeLists, (Class[])currentTypelist.clone());
            if (lookupMode.contains((Object)LookupMode.AUTOBOX) && (autoboxed = TypeUtils.autobox(original)) != null) {
                newTypeList = (Class[])TypeUtils.replaceInArray((Object[])currentTypelist.clone(), index, autoboxed);
                TypeUtils.generateCompatibleTypeLists(index + 1, lookupMode, typeLists, newTypeList);
            }
            if (lookupMode.contains((Object)LookupMode.CAST_TO_INTERFACE)) {
                for (Class<?> iface : original.getInterfaces()) {
                    Class<?>[] newTypeList2 = TypeUtils.replaceInArray((Object[])currentTypelist.clone(), index, iface);
                    TypeUtils.generateCompatibleTypeLists(index + 1, lookupMode, typeLists, newTypeList2);
                }
            }
            if (lookupMode.contains((Object)LookupMode.CAST_TO_SUPER)) {
                Class<?> supertype = original;
                while ((supertype = supertype.getSuperclass()) != null) {
                    newTypeList = TypeUtils.replaceInArray((Object[])currentTypelist.clone(), index, supertype);
                    TypeUtils.generateCompatibleTypeLists(index + 1, lookupMode, typeLists, newTypeList);
                }
            }
            if (lookupMode.contains((Object)LookupMode.COMMON_CONVERT)) {
                for (Class<?> convert : ValueConversionHelper.collectRegisteredCompatibleTargetTypes(original)) {
                    Class<?>[] newTypeList3 = TypeUtils.replaceInArray((Object[])currentTypelist.clone(), index, convert);
                    TypeUtils.generateCompatibleTypeLists(index + 1, lookupMode, typeLists, newTypeList3);
                }
            }
            if (lookupMode.contains((Object)LookupMode.SMART_CONVERT)) {
                for (Class<?> convert : ValueConversionHelper.collectCompatibleTargetTypes(original)) {
                    Class<?>[] newTypeList4 = TypeUtils.replaceInArray((Object[])currentTypelist.clone(), index, convert);
                    TypeUtils.generateCompatibleTypeLists(index + 1, lookupMode, typeLists, newTypeList4);
                }
            }
        }
    }

    @Nullable
    public static Class<?> autobox(Class<?> c) {
        if (c == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.autobox must not be null");
        }
        if (c == Integer.class) {
            return Integer.TYPE;
        }
        if (c == Integer.TYPE) {
            return Integer.class;
        }
        if (c == Boolean.class) {
            return Boolean.TYPE;
        }
        if (c == Boolean.TYPE) {
            return Boolean.class;
        }
        if (c == Character.class) {
            return Character.TYPE;
        }
        if (c == Character.TYPE) {
            return Character.class;
        }
        if (c == Byte.class) {
            return Byte.TYPE;
        }
        if (c == Byte.TYPE) {
            return Byte.class;
        }
        if (c == Short.class) {
            return Short.TYPE;
        }
        if (c == Short.TYPE) {
            return Short.class;
        }
        if (c == Long.class) {
            return Long.TYPE;
        }
        if (c == Long.TYPE) {
            return Long.class;
        }
        if (c == Float.class) {
            return Float.TYPE;
        }
        if (c == Float.TYPE) {
            return Float.class;
        }
        if (c == Double.class) {
            return Double.TYPE;
        }
        if (c == Double.TYPE) {
            return Double.class;
        }
        return null;
    }

    @NotNull
    public static Class<?> widestNumberClass(Number ... numbers) {
        if (numbers == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.widestNumberClass must not be null");
        }
        Integer widest = 0;
        Class widestNumberType = Byte.class;
        for (Number number : numbers) {
            Integer size = numSizes.get(number.getClass());
            if (size <= widest) continue;
            widestNumberType = number.getClass();
            widest = size;
        }
        Class<Byte> clazz = widestNumberType;
        if (clazz == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/TypeUtils.widestNumberClass must not return null");
        }
        return clazz;
    }

    public static boolean isPackage(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.isPackage must not be null");
        }
        return name.equals("java") || Package.getPackage(name) != null;
    }

    @NotNull
    static <T> T[] replaceInArray(T[] array, int index, T value) {
        if (array == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.replaceInArray must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/TypeUtils.replaceInArray must not be null");
        }
        array[index] = value;
        if (array == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/TypeUtils.replaceInArray must not return null");
        }
        return array;
    }

    private TypeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        int size = 0;
        numSizes.put(Byte.class, ++size);
        numSizes.put(Short.class, ++size);
        numSizes.put(Integer.class, ++size);
        numSizes.put(Long.class, ++size);
        numSizes.put(Float.class, ++size);
        numSizes.put(Double.class, ++size);
    }
}

