/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.bbottema.javareflection.LookupCaches;
import org.bbottema.javareflection.PackageUtils;
import org.bbottema.javareflection.model.MethodModifier;
import org.bbottema.javareflection.util.MiscUtil;
import org.bbottema.javareflection.valueconverter.IncompatibleTypeException;
import org.bbottema.javareflection.valueconverter.ValueConversionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassUtils {
    @Nullable
    public static <T> Class<T> locateClass(String className, boolean fullscan, @Nullable ClassLoader classLoader) {
        if (className == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.locateClass must not be null");
        }
        String cacheKey = className + fullscan;
        if (LookupCaches.CLASS_CACHE.containsKey(cacheKey)) {
            return LookupCaches.CLASS_CACHE.get(cacheKey);
        }
        Class<T> _class = fullscan ? ClassUtils.locateClass(className, null, classLoader) : ClassUtils.locateClass(className, "java.lang", classLoader);
        LookupCaches.CLASS_CACHE.put(cacheKey, _class);
        return _class;
    }

    @Nullable
    public static <T> Class<T> locateClass(String className, @Nullable String inPackage, @Nullable ClassLoader classLoader) {
        if (className == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.locateClass must not be null");
        }
        String cacheKey = className + inPackage;
        if (LookupCaches.CLASS_CACHE.containsKey(cacheKey)) {
            return LookupCaches.CLASS_CACHE.get(cacheKey);
        }
        Class<Object> _class = ClassUtils.locateClass(className, classLoader);
        if (_class == null) {
            _class = PackageUtils.scanPackagesForClass(className, inPackage, classLoader);
        }
        LookupCaches.CLASS_CACHE.put(cacheKey, _class);
        return _class;
    }

    @Nullable
    public static <T> Class<T> locateClass(String fullClassName, @Nullable ClassLoader classLoader) {
        if (fullClassName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.locateClass must not be null");
        }
        try {
            Class<?> _class = null;
            if (classLoader != null) {
                _class = classLoader.loadClass(fullClassName);
            }
            if (_class == null) {
                _class = Class.forName(fullClassName);
            }
            return _class;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @NotNull
    public static <T> T newInstanceSimple(Class<T> _class) {
        T t;
        if (_class == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.newInstanceSimple must not be null");
        }
        try {
            t = _class.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException("unable to invoke parameterless constructor; security problem", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("unable to complete instantiation of object", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unable to access parameterless constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("unable to invoke parameterless constructor", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("unable to find parameterless constructor (not public?)", e);
        }
        if (t == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/ClassUtils.newInstanceSimple must not return null");
        }
        return t;
    }

    @Nullable
    public static <T> T solveFieldValue(Object object, String fieldName) {
        if (object == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.solveFieldValue must not be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ClassUtils.solveFieldValue must not be null");
        }
        Field field = ClassUtils.solveField(object, fieldName);
        if (field == null) {
            throw new RuntimeException(new NoSuchFieldException());
        }
        field.setAccessible(true);
        try {
            return MiscUtil.trustedNullableCast(field.get(object));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Was unable to retrieve value from field %s", e);
        }
    }

    @Nullable
    public static Field solveField(Object object, String fieldName) {
        if (object == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.solveField must not be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ClassUtils.solveField must not be null");
        }
        return object.getClass().equals(Class.class) ? ClassUtils.solveField((Class)object, fieldName) : ClassUtils.solveField(object.getClass(), fieldName);
    }

    @Nullable
    public static Field solveField(Class<?> _class, String fieldName) {
        if (_class == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.solveField must not be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ClassUtils.solveField must not be null");
        }
        Field resolvedField = null;
        try {
            resolvedField = _class.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            for (int i = 0; resolvedField == null && i < _class.getInterfaces().length; ++i) {
                resolvedField = ClassUtils.solveField(_class.getInterfaces()[i], fieldName);
            }
            for (Class<?> superclass = _class.getSuperclass(); resolvedField == null && superclass != null; superclass = superclass.getSuperclass()) {
                resolvedField = ClassUtils.solveField(superclass, fieldName);
            }
        }
        return resolvedField;
    }

    @Nullable
    public static Object assignToField(Object o, String property, Object value) throws IllegalAccessException, NoSuchFieldException {
        if (o == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.assignToField must not be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ClassUtils.assignToField must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/ClassUtils.assignToField must not be null");
        }
        Field field = ClassUtils.solveField(o, property);
        if (field != null) {
            field.setAccessible(true);
            Object assignedValue = value;
            try {
                field.set(o, value);
            }
            catch (IllegalArgumentException ie) {
                try {
                    assignedValue = ValueConversionHelper.convert(value, field.getType());
                }
                catch (IncompatibleTypeException e) {
                    throw new NoSuchFieldException(e.getMessage());
                }
                field.set(o, assignedValue);
            }
            return assignedValue;
        }
        throw new NoSuchFieldException();
    }

    @NotNull
    public static Collection<String> collectPropertyNames(Object subject) {
        Field[] fields;
        if (subject == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.collectPropertyNames must not be null");
        }
        LinkedHashSet<String> properties = new LinkedHashSet<String>();
        for (Field f : fields = subject.getClass().getFields()) {
            properties.add(f.getName());
        }
        LinkedHashSet<String> linkedHashSet = properties;
        if (linkedHashSet == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/ClassUtils.collectPropertyNames must not return null");
        }
        return linkedHashSet;
    }

    public static Set<String> collectMethodNames(Class<?> dataType, Class<?> boundaryMarker, EnumSet<MethodModifier> methodModifiers) {
        if (dataType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.collectMethodNames must not be null");
        }
        if (boundaryMarker == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ClassUtils.collectMethodNames must not be null");
        }
        if (methodModifiers == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/ClassUtils.collectMethodNames must not be null");
        }
        HashSet<String> methodNames = new HashSet<String>();
        for (Method m : ClassUtils.collectMethods(dataType, boundaryMarker, methodModifiers)) {
            methodNames.add(m.getName());
        }
        HashSet<String> hashSet = methodNames;
        if (hashSet == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/ClassUtils.collectMethodNames must not return null");
        }
        return hashSet;
    }

    public static List<Method> collectMethodsByName(Class<?> type, Class<?> boundaryMarker, EnumSet<MethodModifier> methodModifiers, String methodName) {
        if (type == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.collectMethodsByName must not be null");
        }
        if (boundaryMarker == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ClassUtils.collectMethodsByName must not be null");
        }
        if (methodModifiers == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/ClassUtils.collectMethodsByName must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/ClassUtils.collectMethodsByName must not be null");
        }
        List<Method> list = ClassUtils.collectMethodsMappingToName(type, boundaryMarker, methodModifiers).get(methodName);
        if (list == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/ClassUtils.collectMethodsByName must not return null");
        }
        return list;
    }

    public static boolean hasMethodByName(Class<?> type, Class<?> boundaryMarker, EnumSet<MethodModifier> methodModifiers, String methodName) {
        if (type == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.hasMethodByName must not be null");
        }
        if (boundaryMarker == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ClassUtils.hasMethodByName must not be null");
        }
        if (methodModifiers == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/ClassUtils.hasMethodByName must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/ClassUtils.hasMethodByName must not be null");
        }
        LinkedHashMap<String, List<Method>> methodsByName = ClassUtils.collectMethodsMappingToName(type, boundaryMarker, methodModifiers);
        return methodsByName.containsKey(methodName) && !methodsByName.get(methodName).isEmpty();
    }

    @Nullable
    public static Method findFirstMethodByName(Class<?> type, Class<?> boundaryMarker, EnumSet<MethodModifier> methodModifiers, String methodName) {
        if (type == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.findFirstMethodByName must not be null");
        }
        if (boundaryMarker == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ClassUtils.findFirstMethodByName must not be null");
        }
        if (methodModifiers == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/ClassUtils.findFirstMethodByName must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/ClassUtils.findFirstMethodByName must not be null");
        }
        List<Method> methods = ClassUtils.collectMethodsByName(type, boundaryMarker, methodModifiers, methodName);
        return methods.isEmpty() ? null : methods.iterator().next();
    }

    public static LinkedHashMap<String, List<Method>> collectMethodsMappingToName(Class<?> type, Class<?> boundaryMarker, EnumSet<MethodModifier> methodModifiers) {
        if (type == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.collectMethodsMappingToName must not be null");
        }
        if (boundaryMarker == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ClassUtils.collectMethodsMappingToName must not be null");
        }
        if (methodModifiers == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/ClassUtils.collectMethodsMappingToName must not be null");
        }
        LinkedHashMap<String, List<Method>> methodsMappedToName = new LinkedHashMap<String, List<Method>>();
        for (Method method : ClassUtils.collectMethods(type, boundaryMarker, methodModifiers)) {
            if (!methodsMappedToName.containsKey(method.getName())) {
                methodsMappedToName.put(method.getName(), new ArrayList());
            }
            methodsMappedToName.get(method.getName()).add(method);
        }
        LinkedHashMap<String, List<Method>> linkedHashMap = methodsMappedToName;
        if (linkedHashMap == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/ClassUtils.collectMethodsMappingToName must not return null");
        }
        return linkedHashMap;
    }

    public static List<Method> collectMethods(Class<?> dataType, Class<?> boundaryMarker, EnumSet<MethodModifier> methodModifiers) {
        if (dataType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.collectMethods must not be null");
        }
        if (boundaryMarker == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ClassUtils.collectMethods must not be null");
        }
        if (methodModifiers == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/ClassUtils.collectMethods must not be null");
        }
        ArrayList<Method> allMethods = new ArrayList<Method>();
        for (Method declaredMethod : dataType.getDeclaredMethods()) {
            if (!MethodModifier.meetsModifierRequirements(declaredMethod, methodModifiers)) continue;
            allMethods.add(declaredMethod);
        }
        if (dataType != boundaryMarker && dataType.getSuperclass() != null) {
            allMethods.addAll(ClassUtils.collectMethods(dataType.getSuperclass(), boundaryMarker, methodModifiers));
        }
        ArrayList<Method> arrayList = allMethods;
        if (arrayList == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/ClassUtils.collectMethods must not return null");
        }
        return arrayList;
    }

    private ClassUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

