/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection.valueconverter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bbottema.javareflection.LookupCaches;
import org.bbottema.javareflection.util.MiscUtil;
import org.bbottema.javareflection.util.graph.GraphHelper;
import org.bbottema.javareflection.util.graph.Node;
import org.bbottema.javareflection.valueconverter.IncompatibleTypeException;
import org.bbottema.javareflection.valueconverter.ValueFunction;
import org.bbottema.javareflection.valueconverter.converters.BooleanConverters;
import org.bbottema.javareflection.valueconverter.converters.CharacterConverters;
import org.bbottema.javareflection.valueconverter.converters.FileConverters;
import org.bbottema.javareflection.valueconverter.converters.NumberConverters;
import org.bbottema.javareflection.valueconverter.converters.StringConverters;
import org.bbottema.javareflection.valueconverter.converters.UUIDConverters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValueConversionHelper {
    private static final List<Class<?>> PRIMITIVE_NUMBER_TYPES = Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
    private static final Map<Class<?>, Map<Class<?>, ValueFunction<Object, Object>>> valueConverters = new HashMap();
    private static final Map<Class<?>, Node<Class<?>>> converterGraph = new HashMap();
    private static final int LOW_CONVERTER_PRIORITY = 10;
    private static final int HIGH_CONVERTER_PRIORITY = 1;

    public static void resetDefaultConverters() {
        valueConverters.clear();
        HashSet defaultConverters = new HashSet();
        defaultConverters.addAll(NumberConverters.NUMBER_CONVERTERS);
        defaultConverters.addAll(BooleanConverters.BOOLEAN_CONVERTERS);
        defaultConverters.addAll(CharacterConverters.CHARACTER_CONVERTERS);
        defaultConverters.addAll(StringConverters.STRING_CONVERTERS);
        defaultConverters.addAll(UUIDConverters.UUID_CONVERTERS);
        defaultConverters.addAll(FileConverters.FILE_CONVERTERS);
        for (ValueFunction valueFunction : defaultConverters) {
            ValueConversionHelper.registerValueConverter(valueFunction);
        }
    }

    public static void registerValueConverter(ValueFunction<?, ?> userConverter) {
        if (userConverter == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.registerValueConverter must not be null");
        }
        if (!valueConverters.containsKey(userConverter.getFromType())) {
            valueConverters.put(userConverter.getFromType(), new HashMap());
        }
        valueConverters.get(userConverter.getFromType()).put(userConverter.getTargetType(), (ValueFunction<Object, Object>)MiscUtil.trustedCast(userConverter));
        ValueConversionHelper.updateTypeGraph();
        LookupCaches.resetCache();
    }

    private static void updateTypeGraph() {
        converterGraph.clear();
        for (Map.Entry<Class<?>, Map<Class<?>, ValueFunction<Object, Object>>> convertersForFromType : valueConverters.entrySet()) {
            Class<?> fromType = convertersForFromType.getKey();
            Node fromNode = converterGraph.containsKey(fromType) ? converterGraph.get(fromType) : new Node(fromType);
            converterGraph.put(fromType, fromNode);
            for (Class<?> toType : convertersForFromType.getValue().keySet()) {
                Node toNode = converterGraph.containsKey(toType) ? converterGraph.get(toType) : new Node(toType);
                converterGraph.put(toType, toNode);
                ValueFunction<Object, Object> converter = convertersForFromType.getValue().get(toType);
                fromNode.getToNodes().put(toNode, ValueConversionHelper.determineConversionCost(converter));
            }
        }
    }

    private static Integer determineConversionCost(ValueFunction<Object, Object> converter) {
        if (converter == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.determineConversionCost must not be null");
        }
        if (converter.getFromType() == converter.getTargetType()) {
            Integer n = 0;
            if (n == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/ValueConversionHelper.determineConversionCost must not return null");
            }
            return n;
        }
        String converterPackage = ValueConversionHelper.class.getPackage().toString();
        boolean isSystemConverter = converter.getClass().getPackage().toString().contains(converterPackage);
        Integer n = isSystemConverter ? 10 : 1;
        if (n == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/ValueConversionHelper.determineConversionCost must not return null");
        }
        return n;
    }

    public static boolean isCommonType(Class<?> c) {
        if (c == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.isCommonType must not be null");
        }
        Map<Class<?>, ValueFunction<Object, Object>> classValueFunctionMap = valueConverters.get(c);
        return valueConverters.containsKey(c) && (classValueFunctionMap.keySet().size() > 1 || !classValueFunctionMap.keySet().contains(String.class));
    }

    @NotNull
    public static Set<Class<?>> collectRegisteredCompatibleTargetTypes(Class<?> fromType) {
        if (fromType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.collectRegisteredCompatibleTargetTypes must not be null");
        }
        HashSet compatibleTypes = new HashSet(Collections.singleton(fromType));
        if (converterGraph.containsKey(fromType)) {
            for (Node<Class<?>> reachableNode : GraphHelper.findReachableNodes(converterGraph.get(fromType))) {
                compatibleTypes.add(reachableNode.getType());
            }
        }
        HashSet hashSet = compatibleTypes;
        if (hashSet == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/ValueConversionHelper.collectRegisteredCompatibleTargetTypes must not return null");
        }
        return hashSet;
    }

    public static boolean typesCompatible(Class<?> fromType, Class<?> targetType) {
        if (fromType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.typesCompatible must not be null");
        }
        if (targetType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.typesCompatible must not be null");
        }
        if (targetType.isAssignableFrom(fromType)) {
            return true;
        }
        for (Class<?> registeredCompatibleTargetType : ValueConversionHelper.collectCompatibleTargetTypes(fromType)) {
            if (!targetType.isAssignableFrom(registeredCompatibleTargetType)) continue;
            return true;
        }
        return false;
    }

    public static Set<Class<?>> collectCompatibleTargetTypes(Class<?> fromType) {
        if (fromType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.collectCompatibleTargetTypes must not be null");
        }
        ValueConversionHelper.checkForAndRegisterToStringConverter(fromType);
        HashSet compatibleTargetTypes = new HashSet();
        Node<Class<?>> fromNode = converterGraph.get(fromType);
        for (Map<Class<?>, ValueFunction<Object, Object>> convertersForFromTypes : valueConverters.values()) {
            for (Class<?> targetType : convertersForFromTypes.keySet()) {
                if (!ValueConversionHelper.isCompatibleTargetType(fromNode, targetType)) continue;
                compatibleTargetTypes.add(targetType);
            }
        }
        HashSet hashSet = compatibleTargetTypes;
        if (hashSet == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/ValueConversionHelper.collectCompatibleTargetTypes must not return null");
        }
        return hashSet;
    }

    private static boolean isCompatibleTargetType(Node<Class<?>> fromNode, Class<?> targetType) {
        if (fromNode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.isCompatibleTargetType must not be null");
        }
        if (targetType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.isCompatibleTargetType must not be null");
        }
        for (Node<Class<?>> toNode : ValueConversionHelper.collectTypeCompatibleNodes(targetType)) {
            if (!GraphHelper.isPathPossible(fromNode, toNode)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Object[] convert(Object[] args, Class<?>[] targetTypes, boolean useOriginalValueWhenIncompatible) throws IncompatibleTypeException {
        if (args == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.convert must not be null");
        }
        if (targetTypes == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.convert must not be null");
        }
        if (args.length != targetTypes.length) {
            throw new IllegalStateException("number of target types should match the number of arguments");
        }
        Object[] convertedValues = new Object[args.length];
        for (int i = 0; i < targetTypes.length; ++i) {
            try {
                convertedValues[i] = ValueConversionHelper.convert(args[i], targetTypes[i]);
                continue;
            }
            catch (IncompatibleTypeException e) {
                if (useOriginalValueWhenIncompatible) {
                    convertedValues[i] = args[i];
                    continue;
                }
                throw e;
            }
        }
        if (convertedValues == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/ValueConversionHelper.convert must not return null");
        }
        return convertedValues;
    }

    @Nullable
    public static <T> T convert(@Nullable Object fromValue, Class<T> targetType) throws IncompatibleTypeException {
        if (targetType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.convert must not be null");
        }
        if (fromValue == null) {
            return null;
        }
        if (targetType.isAssignableFrom(fromValue.getClass())) {
            return ValueConversionHelper.convertWithoutConversionGraph(fromValue, targetType);
        }
        ValueConversionHelper.checkForAndRegisterEnumConverter(targetType);
        ValueConversionHelper.checkForAndRegisterToStringConverter(fromValue.getClass());
        return ValueConversionHelper.convertWithConversionGraph(fromValue, targetType);
    }

    @NotNull
    private static <T> T convertWithoutConversionGraph(Object fromValue, Class<T> targetType) {
        Map<Class<?>, ValueFunction<Object, Object>> fromConverters;
        if (fromValue == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.convertWithoutConversionGraph must not be null");
        }
        if (targetType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.convertWithoutConversionGraph must not be null");
        }
        if (valueConverters.containsKey(fromValue.getClass()) && (fromConverters = valueConverters.get(fromValue.getClass())).containsKey(targetType)) {
            Object t;
            try {
                t = MiscUtil.trustedCast(fromConverters.get(targetType).convertValue(fromValue));
            }
            catch (IncompatibleTypeException incompatibleTypeException) {
                // empty catch block
            }
            if (t == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/ValueConversionHelper.convertWithoutConversionGraph must not return null");
            }
            return t;
        }
        Object t = MiscUtil.trustedCast(fromValue);
        if (t == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/ValueConversionHelper.convertWithoutConversionGraph must not return null");
        }
        return t;
    }

    @NotNull
    private static <T> T convertWithConversionGraph(Object fromValue, Class<T> targetType) {
        if (fromValue == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.convertWithConversionGraph must not be null");
        }
        if (targetType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.convertWithConversionGraph must not be null");
        }
        Node<Class<?>> fromNode = converterGraph.get(fromValue.getClass());
        ArrayList<IncompatibleTypeException> incompatibleTypeExceptions = new ArrayList<IncompatibleTypeException>();
        if (fromNode != null) {
            for (Node<Class<?>> toNode : ValueConversionHelper.collectTypeCompatibleNodes(targetType)) {
                for (List<Node<Class<?>>> conversionPathAscending : GraphHelper.findAllPathsAscending(fromNode, toNode)) {
                    Object object;
                    try {
                        Object evolvingValueToConvert = fromValue;
                        for (Node<Class<?>> nodeInConversionPath : conversionPathAscending) {
                            Class<?> currentFromType = evolvingValueToConvert.getClass();
                            Class<?> currentToType = nodeInConversionPath.getType();
                            evolvingValueToConvert = valueConverters.get(currentFromType).get(currentToType).convertValue(evolvingValueToConvert);
                        }
                        object = evolvingValueToConvert;
                    }
                    catch (IncompatibleTypeException e) {
                        incompatibleTypeExceptions.add(e);
                        continue;
                    }
                    if (object == null) {
                        throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/ValueConversionHelper.convertWithConversionGraph must not return null");
                    }
                    return (T)object;
                }
            }
        }
        throw new IncompatibleTypeException(fromValue, fromValue.getClass(), targetType, incompatibleTypeExceptions);
    }

    private static <T extends Enum<T>> void checkForAndRegisterEnumConverter(Class<?> targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.checkForAndRegisterEnumConverter must not be null");
        }
        if (Enum.class.isAssignableFrom(targetType) && !valueConverters.get(String.class).containsKey(targetType)) {
            ValueConversionHelper.registerValueConverter(StringConverters.produceStringToEnumConverter(targetType));
        }
    }

    private static void checkForAndRegisterToStringConverter(Class<?> fromType) {
        if (fromType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.checkForAndRegisterToStringConverter must not be null");
        }
        if (!valueConverters.containsKey(fromType) || !valueConverters.get(fromType).containsKey(String.class)) {
            ValueConversionHelper.registerValueConverter(StringConverters.produceTypeToStringConverter(fromType));
        }
    }

    static Set<Node<Class<?>>> collectTypeCompatibleNodes(Class<?> targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.collectTypeCompatibleNodes must not be null");
        }
        HashSet typeCompatibleNodes = new HashSet();
        for (Map.Entry<Class<?>, Node<Class<?>>> converterNodeEntry : converterGraph.entrySet()) {
            if (!targetType.isAssignableFrom(converterNodeEntry.getKey())) continue;
            typeCompatibleNodes.add(converterNodeEntry.getValue());
        }
        HashSet hashSet = typeCompatibleNodes;
        if (hashSet == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/ValueConversionHelper.collectTypeCompatibleNodes must not return null");
        }
        return hashSet;
    }

    public static boolean isPrimitiveNumber(Class<?> targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/ValueConversionHelper.isPrimitiveNumber must not be null");
        }
        return PRIMITIVE_NUMBER_TYPES.contains(targetType);
    }

    private ValueConversionHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        ValueConversionHelper.resetDefaultConverters();
    }
}

