/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bbottema.javareflection.ClassUtils;
import org.bbottema.javareflection.TypeUtils;
import org.bbottema.javareflection.model.InvokableObject;
import org.bbottema.javareflection.model.LookupMode;
import org.bbottema.javareflection.valueconverter.IncompatibleTypeException;
import org.bbottema.javareflection.valueconverter.ValueConversionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MethodUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodUtils.class);
    private static final Map<Class<?>, Map<String, Map<InvokableObject, Class<?>[]>>> methodCache = new LinkedHashMap();

    public static void resetCache() {
        methodCache.clear();
    }

    @Nullable
    public static <T> T invokeCompatibleMethod(@Nullable Object context, Class<?> datatype, String identifier, Object ... args) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        InvokableObject<Method> iMethod;
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.invokeCompatibleMethod must not be null");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.invokeCompatibleMethod must not be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/MethodUtils.invokeCompatibleMethod must not be null");
        }
        Class<?>[] parameterList = TypeUtils.collectTypes(args);
        EnumSet<LookupMode> lookupMode = EnumSet.of(LookupMode.AUTOBOX, LookupMode.CAST_TO_SUPER);
        try {
            iMethod = MethodUtils.findCompatibleMethod(datatype, identifier, lookupMode, parameterList);
        }
        catch (NoSuchMethodException e1) {
            try {
                lookupMode.add(LookupMode.CAST_TO_INTERFACE);
                iMethod = MethodUtils.findCompatibleMethod(datatype, identifier, lookupMode, parameterList);
            }
            catch (NoSuchMethodException e2) {
                try {
                    lookupMode.add(LookupMode.COMMON_CONVERT);
                    iMethod = MethodUtils.findCompatibleMethod(datatype, identifier, lookupMode, parameterList);
                }
                catch (NoSuchMethodException e3) {
                    lookupMode.add(LookupMode.SMART_CONVERT);
                    iMethod = MethodUtils.findCompatibleMethod(datatype, identifier, lookupMode, parameterList);
                }
            }
        }
        Method method = iMethod.getMethod();
        method.setAccessible(true);
        try {
            Object[] convertedArgs = ValueConversionHelper.convert(args, iMethod.getCompatibleSignature(), false);
            return (T)method.invoke(context, convertedArgs);
        }
        catch (IncompatibleTypeException e) {
            LOGGER.error("Found a method with compatible parameter list, but not all parameters could be converted", (Throwable)e);
            throw new NoSuchMethodException();
        }
    }

    @NotNull
    public static <T> T invokeCompatibleConstructor(Class<T> datatype, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.invokeCompatibleConstructor must not be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.invokeCompatibleConstructor must not be null");
        }
        Class<?>[] parameterList = TypeUtils.collectTypes(args);
        T t = MethodUtils.invokeConstructor(datatype, parameterList, args);
        if (t == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.invokeCompatibleConstructor must not return null");
        }
        return t;
    }

    @NotNull
    public static <T> T invokeConstructor(Class<T> datatype, Class<?>[] signature, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object t;
        InvokableObject<Constructor> iConstructor;
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.invokeConstructor must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.invokeConstructor must not be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.invokeConstructor must not be null");
        }
        EnumSet<LookupMode> lookupMode = EnumSet.of(LookupMode.AUTOBOX, LookupMode.CAST_TO_SUPER);
        try {
            iConstructor = MethodUtils.findCompatibleConstructor(datatype, lookupMode, signature);
        }
        catch (NoSuchMethodException e1) {
            try {
                lookupMode.add(LookupMode.CAST_TO_INTERFACE);
                iConstructor = MethodUtils.findCompatibleConstructor(datatype, lookupMode, signature);
            }
            catch (NoSuchMethodException e2) {
                try {
                    lookupMode.add(LookupMode.COMMON_CONVERT);
                    iConstructor = MethodUtils.findCompatibleConstructor(datatype, lookupMode, signature);
                }
                catch (NoSuchMethodException e3) {
                    lookupMode.add(LookupMode.SMART_CONVERT);
                    iConstructor = MethodUtils.findCompatibleConstructor(datatype, lookupMode, signature);
                }
            }
        }
        try {
            Object[] convertedArgs = ValueConversionHelper.convert(args, iConstructor.getCompatibleSignature(), false);
            t = iConstructor.getMethod().newInstance(convertedArgs);
        }
        catch (IncompatibleTypeException e) {
            LOGGER.error("Found a constructor with compatible parameter list, but not all parameters could be converted", (Throwable)e);
            throw new NoSuchMethodException();
        }
        if (t == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.invokeConstructor must not return null");
        }
        return t;
    }

    public static <T> InvokableObject<Constructor> findCompatibleConstructor(Class<T> datatype, EnumSet<LookupMode> lookupMode, Class<?> ... signature) throws NoSuchMethodException {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.findCompatibleConstructor must not be null");
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.findCompatibleConstructor must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.findCompatibleConstructor must not be null");
        }
        InvokableObject<Constructor> constructor = MethodUtils.getConstructorFromCache(datatype, datatype.getName(), signature);
        if (constructor != null) {
            InvokableObject<Constructor> invokableObject = constructor;
            if (invokableObject == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.findCompatibleConstructor must not return null");
            }
            return invokableObject;
        }
        try {
            constructor = new InvokableObject<Constructor<Constructor>>(datatype.getConstructor(signature), signature, signature);
        }
        catch (NoSuchMethodException e) {
            List<Class<?>[]> compatibleSignatures = TypeUtils.generateCompatibleTypeLists(lookupMode, signature);
            for (Class<?>[] compatibleSignature : compatibleSignatures) {
                try {
                    constructor = new InvokableObject<Constructor<Constructor>>(datatype.getConstructor(compatibleSignature), signature, compatibleSignature);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        if (constructor != null) {
            MethodUtils.addMethodToCache(datatype, datatype.getName(), constructor, signature);
            InvokableObject<Constructor> invokableObject = constructor;
            if (invokableObject == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.findCompatibleConstructor must not return null");
            }
            return invokableObject;
        }
        throw new NoSuchMethodException();
    }

    @Nullable
    public static InvokableObject<Method> findSimpleCompatibleMethod(Class<?> datatype, String methodName, Class<?> ... signature) {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.findSimpleCompatibleMethod must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.findSimpleCompatibleMethod must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.findSimpleCompatibleMethod must not be null");
        }
        try {
            return MethodUtils.findCompatibleMethod(datatype, methodName, EnumSet.noneOf(LookupMode.class), signature);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @NotNull
    public static InvokableObject<Method> findCompatibleMethod(Class<?> datatype, String methodName, EnumSet<LookupMode> lookupMode, Class<?> ... signature) throws NoSuchMethodException {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.findCompatibleMethod must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.findCompatibleMethod must not be null");
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.findCompatibleMethod must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/MethodUtils.findCompatibleMethod must not be null");
        }
        InvokableObject<Method> iMethod = MethodUtils.getMethodFromCache(datatype, methodName, signature);
        if (iMethod != null) {
            InvokableObject<Method> invokableObject = iMethod;
            if (invokableObject == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.findCompatibleMethod must not return null");
            }
            return invokableObject;
        }
        try {
            iMethod = new InvokableObject<Method>(MethodUtils.getMethod(datatype, methodName, signature), signature, signature);
        }
        catch (NoSuchMethodException e) {
            List<Class<?>[]> signatures = TypeUtils.generateCompatibleTypeLists(lookupMode, signature);
            for (Class<?>[] compatibleSignature : signatures) {
                try {
                    iMethod = new InvokableObject<Method>(MethodUtils.getMethod(datatype, methodName, compatibleSignature), signature, compatibleSignature);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        if (iMethod != null) {
            MethodUtils.addMethodToCache(datatype, methodName, iMethod, signature);
            InvokableObject<Method> invokableObject = iMethod;
            if (invokableObject == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.findCompatibleMethod must not return null");
            }
            return invokableObject;
        }
        throw new NoSuchMethodException();
    }

    @NotNull
    public static Method getMethod(Class<?> datatype, String name, Class<?> ... signature) throws NoSuchMethodException {
        Method method;
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.getMethod must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.getMethod must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.getMethod must not be null");
        }
        for (Class<?> iface : datatype.getInterfaces()) {
            Method method2;
            try {
                method2 = iface.getMethod(name, signature);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            if (method2 == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.getMethod must not return null");
            }
            return method2;
        }
        try {
            method = datatype.getMethod(name, signature);
        }
        catch (NoSuchMethodException e) {
            Method method3 = datatype.getDeclaredMethod(name, signature);
            if (method3 == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.getMethod must not return null");
            }
            return method3;
        }
        if (method == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.getMethod must not return null");
        }
        return method;
    }

    public static boolean isMethodCompatible(Method method, EnumSet<LookupMode> lookupMode, Class<?> ... signature) {
        if (method == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.isMethodCompatible must not be null");
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.isMethodCompatible must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.isMethodCompatible must not be null");
        }
        Class<?>[] targetSignature = method.getParameterTypes();
        if (signature.length != targetSignature.length) {
            return false;
        }
        return TypeUtils.isTypeListCompatible(signature, targetSignature, lookupMode);
    }

    @Nullable
    private static <T> InvokableObject getInvokableObjectFromCache(Class<T> datatype, String method, Class<?> ... signature) {
        Map<InvokableObject, Class<?>[]> signatures;
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.getInvokableObjectFromCache must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.getInvokableObjectFromCache must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.getInvokableObjectFromCache must not be null");
        }
        Map<String, Map<InvokableObject, Class<?>[]>> owner = methodCache.get(datatype);
        if (signature.length > 0 && owner != null && (signatures = owner.get(method)) != null) {
            for (Map.Entry<InvokableObject, Class<?>[]> entry : signatures.entrySet()) {
                if (!Arrays.equals(entry.getValue(), signature)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    @Nullable
    private static <T> InvokableObject<Method> getMethodFromCache(Class<T> datatype, String method, Class<?> ... signature) {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.getMethodFromCache must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.getMethodFromCache must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.getMethodFromCache must not be null");
        }
        return MethodUtils.getInvokableObjectFromCache(datatype, method, signature);
    }

    @Nullable
    private static <T> InvokableObject<Constructor> getConstructorFromCache(Class<T> datatype, String method, Class<?> ... signature) {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.getConstructorFromCache must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.getConstructorFromCache must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.getConstructorFromCache must not be null");
        }
        return MethodUtils.getInvokableObjectFromCache(datatype, method, signature);
    }

    private static void addMethodToCache(Class<?> datatype, String method, InvokableObject methodRef, Class<?> ... signature) {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.addMethodToCache must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.addMethodToCache must not be null");
        }
        if (methodRef == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.addMethodToCache must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/MethodUtils.addMethodToCache must not be null");
        }
        if (signature.length > 0) {
            LinkedHashMap<String, Map> owner = methodCache.get(datatype);
            owner = owner != null ? owner : new LinkedHashMap<String, Map>();
            Map methods = (Map)owner.get(method);
            methods = methods != null ? methods : new LinkedHashMap();
            methods.put(methodRef, signature);
            methods.put(methodRef, signature);
            owner.put(method, methods);
            methodCache.put(datatype, owner);
        }
    }

    public static Set<Method> findMatchingMethods(Class<?> datatype, String methodName, String ... paramTypeNames) {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.findMatchingMethods must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.findMatchingMethods must not be null");
        }
        if (paramTypeNames == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.findMatchingMethods must not be null");
        }
        HashSet<Method> matchingMethods = new HashSet<Method>();
        for (Method method : ClassUtils.collectMethods(datatype, false)) {
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            if (!method.getName().equals(methodName) || methodParameterTypes.length != paramTypeNames.length || !MethodUtils.typeNamesMatch(methodParameterTypes, paramTypeNames)) continue;
            matchingMethods.add(method);
        }
        HashSet<Method> hashSet = matchingMethods;
        if (hashSet == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.findMatchingMethods must not return null");
        }
        return hashSet;
    }

    private static boolean typeNamesMatch(Class<?>[] parameterTypes, String[] typeNamesToMatch) {
        if (parameterTypes == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.typeNamesMatch must not be null");
        }
        if (typeNamesToMatch == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.typeNamesMatch must not be null");
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            String typeNameToMatch = typeNamesToMatch[i];
            if (parameterType.getName().equals(typeNameToMatch) || parameterType.getSimpleName().equals(typeNameToMatch)) continue;
            return false;
        }
        return true;
    }

    private MethodUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

